/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import java.util.HashMap;
import java.util.Map;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Library;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugLibraryMapEntry;
import org.opencds.cqf.cql.engine.debug.DebugLocator;
import org.opencds.cqf.cql.engine.debug.DebugMapEntry;

public class DebugMap {
    private Map<String, DebugLibraryMapEntry> libraryMaps = new HashMap<String, DebugLibraryMapEntry>();
    private Map<String, DebugMapEntry> nodeTypeEntries = new HashMap<String, DebugMapEntry>();
    private Map<String, DebugMapEntry> exceptionTypeEntries = new HashMap<String, DebugMapEntry>();
    private boolean isLoggingEnabled;
    private boolean isCoverageEnabled;

    public DebugAction shouldDebug(Exception e) {
        if (this.exceptionTypeEntries.size() == 0) {
            return DebugAction.LOG;
        }
        DebugMapEntry exceptionTypeEntry = this.exceptionTypeEntries.get(e.getClass().getSimpleName());
        if (exceptionTypeEntry != null) {
            return exceptionTypeEntry.getAction();
        }
        return DebugAction.LOG;
    }

    public DebugAction shouldDebug(Element node, Library currentLibrary) {
        DebugAction action;
        DebugLibraryMapEntry libraryMap = this.libraryMaps.get(currentLibrary.getIdentifier().getId());
        if (libraryMap != null && (action = libraryMap.shouldDebug(node)) != DebugAction.NONE) {
            return action;
        }
        DebugMapEntry nodeEntry = this.nodeTypeEntries.get(node.getClass().getSimpleName());
        if (nodeEntry != null && nodeEntry.getAction() != DebugAction.NONE) {
            return nodeEntry.getAction();
        }
        if (this.isLoggingEnabled) {
            return DebugAction.LOG;
        }
        if (this.isCoverageEnabled) {
            return DebugAction.TRACE;
        }
        return DebugAction.NONE;
    }

    private DebugLibraryMapEntry getLibraryMap(String libraryName) {
        return this.libraryMaps.get(libraryName);
    }

    private DebugLibraryMapEntry ensureLibraryMap(String libraryName) {
        DebugLibraryMapEntry libraryMap = this.libraryMaps.get(libraryName);
        if (libraryMap == null) {
            libraryMap = new DebugLibraryMapEntry(libraryName);
            this.libraryMaps.put(libraryName, libraryMap);
        }
        return libraryMap;
    }

    public void addDebugEntry(DebugLocator debugLocator, DebugAction action) {
        this.addDebugEntry(null, debugLocator, action);
    }

    public void addDebugEntry(String libraryName, DebugLocator debugLocator, DebugAction action) {
        switch (debugLocator.getLocatorType()) {
            case NODE_TYPE: {
                this.nodeTypeEntries.put(debugLocator.getLocator(), new DebugMapEntry(debugLocator, action));
                break;
            }
            case EXCEPTION_TYPE: {
                this.exceptionTypeEntries.put(debugLocator.getLocator(), new DebugMapEntry(debugLocator, action));
                break;
            }
            default: {
                if (libraryName != null) {
                    DebugLibraryMapEntry libraryMap = this.ensureLibraryMap(libraryName);
                    libraryMap.addEntry(debugLocator, action);
                    break;
                }
                throw new IllegalArgumentException("Library entries must have a library name specified");
            }
        }
    }

    public void removeDebugEntry(String libraryName, DebugLocator debugLocator) {
        switch (debugLocator.getLocatorType()) {
            case NODE_TYPE: {
                this.nodeTypeEntries.remove(debugLocator.getLocator());
                break;
            }
            case EXCEPTION_TYPE: {
                this.exceptionTypeEntries.remove(debugLocator.getLocator());
                break;
            }
            default: {
                if (libraryName != null) {
                    DebugLibraryMapEntry libraryMap = this.getLibraryMap(libraryName);
                    if (libraryMap == null) break;
                    libraryMap.removeEntry(debugLocator);
                    break;
                }
                throw new IllegalArgumentException("Library entries must have a library name specified");
            }
        }
    }

    public void removeDebugEntry(DebugLocator debugLocator) {
        this.removeDebugEntry(null, debugLocator);
    }

    public boolean getIsLoggingEnabled() {
        return this.isLoggingEnabled;
    }

    public void setIsLoggingEnabled(boolean isLoggingEnabled) {
        this.isLoggingEnabled = isLoggingEnabled;
    }

    public boolean getIsCoverageEnabled() {
        return this.isCoverageEnabled;
    }

    public void setIsCoverageEnabled(boolean isCoverageEnabled) {
        this.isCoverageEnabled = isCoverageEnabled;
    }
}

