/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.visiting;

import org.cqframework.cql.elm.visiting.ElmBaseVisitor;
import org.cqframework.cql.elm.visiting.ElmClinicalVisitor;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeFilterElement;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.DateFilterElement;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.OtherFilterElement;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Ratio;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.Search;
import org.hl7.elm.r1.SubsumedBy;
import org.hl7.elm.r1.Subsumes;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;

public class ElmBaseClinicalVisitor<T, C>
extends ElmBaseVisitor<T, C>
implements ElmClinicalVisitor<T, C> {
    @Override
    public T visitElement(Element elm, C context) {
        if (elm instanceof CodeDef) {
            return this.visitCodeDef((CodeDef)elm, context);
        }
        if (elm instanceof CodeSystemDef) {
            return this.visitCodeSystemDef((CodeSystemDef)elm, context);
        }
        if (elm instanceof ValueSetDef) {
            return this.visitValueSetDef((ValueSetDef)elm, context);
        }
        if (elm instanceof ConceptDef) {
            return this.visitConceptDef((ConceptDef)elm, context);
        }
        if (elm instanceof CodeFilterElement) {
            return this.visitCodeFilterElement((CodeFilterElement)elm, context);
        }
        if (elm instanceof DateFilterElement) {
            return this.visitDateFilterElement((DateFilterElement)elm, context);
        }
        if (elm instanceof OtherFilterElement) {
            return this.visitOtherFilterElement((OtherFilterElement)elm, context);
        }
        if (elm instanceof IncludeElement) {
            return this.visitIncludeElement((IncludeElement)elm, context);
        }
        return super.visitElement(elm, context);
    }

    @Override
    public T visitExpression(Expression elm, C context) {
        if (elm instanceof Code) {
            return this.visitCode((Code)elm, context);
        }
        if (elm instanceof CodeSystemRef) {
            return this.visitCodeSystemRef((CodeSystemRef)elm, context);
        }
        if (elm instanceof ValueSetRef) {
            return this.visitValueSetRef((ValueSetRef)elm, context);
        }
        if (elm instanceof CodeRef) {
            return this.visitCodeRef((CodeRef)elm, context);
        }
        if (elm instanceof ConceptRef) {
            return this.visitConceptRef((ConceptRef)elm, context);
        }
        if (elm instanceof Concept) {
            return this.visitConcept((Concept)elm, context);
        }
        if (elm instanceof Quantity) {
            return this.visitQuantity((Quantity)elm, context);
        }
        if (elm instanceof Ratio) {
            return this.visitRatio((Ratio)elm, context);
        }
        if (elm instanceof Retrieve) {
            return this.visitRetrieve((Retrieve)elm, context);
        }
        return super.visitExpression(elm, context);
    }

    @Override
    public T visitOperatorExpression(OperatorExpression elm, C context) {
        if (elm instanceof InCodeSystem) {
            return this.visitInCodeSystem((InCodeSystem)elm, context);
        }
        if (elm instanceof AnyInCodeSystem) {
            return this.visitAnyInCodeSystem((AnyInCodeSystem)elm, context);
        }
        if (elm instanceof InValueSet) {
            return this.visitInValueSet((InValueSet)elm, context);
        }
        if (elm instanceof AnyInValueSet) {
            return this.visitAnyInValueSet((AnyInValueSet)elm, context);
        }
        return super.visitOperatorExpression(elm, context);
    }

    @Override
    public T visitUnaryExpression(UnaryExpression elm, C context) {
        if (elm instanceof CalculateAge) {
            return this.visitCalculateAge((CalculateAge)elm, context);
        }
        return super.visitUnaryExpression(elm, context);
    }

    @Override
    public T visitBinaryExpression(BinaryExpression elm, C context) {
        if (elm instanceof CalculateAgeAt) {
            return this.visitCalculateAgeAt((CalculateAgeAt)elm, context);
        }
        if (elm instanceof Subsumes) {
            return this.visitSubsumes((Subsumes)elm, context);
        }
        if (elm instanceof SubsumedBy) {
            return this.visitSubsumedBy((SubsumedBy)elm, context);
        }
        return super.visitBinaryExpression(elm, context);
    }

    @Override
    public T visitCodeFilterElement(CodeFilterElement elm, C context) {
        if (elm.getValue() != null) {
            this.visitElement(elm.getValue(), context);
        }
        return null;
    }

    @Override
    public T visitDateFilterElement(DateFilterElement elm, C context) {
        if (elm.getValue() != null) {
            this.visitElement(elm.getValue(), context);
        }
        return null;
    }

    @Override
    public T visitOtherFilterElement(OtherFilterElement elm, C context) {
        if (elm.getValue() != null) {
            this.visitElement(elm.getValue(), context);
        }
        return null;
    }

    @Override
    public T visitIncludeElement(IncludeElement elm, C context) {
        return null;
    }

    @Override
    public T visitRetrieve(Retrieve elm, C context) {
        if (elm.getCodes() != null) {
            this.visitElement(elm.getCodes(), context);
        }
        if (elm.getDateRange() != null) {
            this.visitElement(elm.getDateRange(), context);
        }
        if (elm.getContext() != null) {
            this.visitElement(elm.getContext(), context);
        }
        for (IncludeElement ie : elm.getInclude()) {
            this.visitElement(ie, context);
        }
        for (CodeFilterElement cfe : elm.getCodeFilter()) {
            this.visitElement(cfe, context);
        }
        for (DateFilterElement dfe : elm.getDateFilter()) {
            this.visitElement(dfe, context);
        }
        for (OtherFilterElement ofe : elm.getOtherFilter()) {
            this.visitElement(ofe, context);
        }
        return null;
    }

    @Override
    public T visitProperty(Property elm, C context) {
        Object result = super.visitProperty(elm, context);
        if (elm instanceof Search) {
            this.visitSearch((Search)elm, context);
        }
        return result;
    }

    @Override
    public T visitSearch(Search elm, C context) {
        return null;
    }

    @Override
    public T visitCodeSystemDef(CodeSystemDef elm, C context) {
        if (elm.getAccessLevel() != null) {
            this.visitAccessModifier(elm.getAccessLevel(), context);
        }
        return null;
    }

    @Override
    public T visitValueSetDef(ValueSetDef elm, C context) {
        if (elm.getAccessLevel() != null) {
            this.visitAccessModifier(elm.getAccessLevel(), context);
        }
        elm.getCodeSystem().stream().forEach(codeSystem -> this.visitCodeSystemRef((CodeSystemRef)codeSystem, context));
        return null;
    }

    @Override
    public T visitCodeDef(CodeDef elm, C context) {
        if (elm.getAccessLevel() != null) {
            this.visitAccessModifier(elm.getAccessLevel(), context);
        }
        if (elm.getCodeSystem() != null) {
            this.visitCodeSystemRef(elm.getCodeSystem(), context);
        }
        return null;
    }

    @Override
    public T visitConceptDef(ConceptDef elm, C context) {
        if (elm.getAccessLevel() != null) {
            this.visitAccessModifier(elm.getAccessLevel(), context);
        }
        for (CodeRef cr : elm.getCode()) {
            this.visitElement(cr, context);
        }
        return null;
    }

    @Override
    public T visitCodeSystemRef(CodeSystemRef elm, C context) {
        return null;
    }

    @Override
    public T visitValueSetRef(ValueSetRef elm, C context) {
        return null;
    }

    @Override
    public T visitCodeRef(CodeRef elm, C context) {
        return null;
    }

    @Override
    public T visitConceptRef(ConceptRef elm, C context) {
        return null;
    }

    @Override
    public T visitCode(Code elm, C context) {
        if (elm.getSystem() != null) {
            this.visitElement(elm.getSystem(), context);
        }
        return null;
    }

    @Override
    public T visitConcept(Concept elm, C context) {
        for (Code c : elm.getCode()) {
            this.visitElement(c, context);
        }
        return null;
    }

    @Override
    public T visitInCodeSystem(InCodeSystem elm, C context) {
        if (elm.getCode() != null) {
            this.visitElement(elm.getCode(), context);
        }
        if (elm.getCodesystem() != null) {
            this.visitElement(elm.getCodesystem(), context);
        }
        return null;
    }

    @Override
    public T visitAnyInCodeSystem(AnyInCodeSystem elm, C context) {
        if (elm.getCodes() != null) {
            this.visitElement(elm.getCodes(), context);
        }
        if (elm.getCodesystem() != null) {
            this.visitElement(elm.getCodesystem(), context);
        }
        return null;
    }

    @Override
    public T visitInValueSet(InValueSet elm, C context) {
        if (elm.getCode() != null) {
            this.visitElement(elm.getCode(), context);
        }
        if (elm.getValueset() != null) {
            this.visitElement(elm.getValueset(), context);
        }
        return null;
    }

    @Override
    public T visitAnyInValueSet(AnyInValueSet elm, C context) {
        if (elm.getCodes() != null) {
            this.visitElement(elm.getCodes(), context);
        }
        if (elm.getValueset() != null) {
            this.visitElement(elm.getValueset(), context);
        }
        return null;
    }

    @Override
    public T visitSubsumes(Subsumes elm, C context) {
        return null;
    }

    @Override
    public T visitSubsumedBy(SubsumedBy elm, C context) {
        return null;
    }

    @Override
    public T visitQuantity(Quantity elm, C context) {
        return null;
    }

    @Override
    public T visitRatio(Ratio elm, C context) {
        if (elm.getDenominator() != null) {
            this.visitElement(elm.getDenominator(), context);
        }
        if (elm.getNumerator() != null) {
            this.visitElement(elm.getNumerator(), context);
        }
        return null;
    }

    @Override
    public T visitCalculateAge(CalculateAge elm, C context) {
        return null;
    }

    @Override
    public T visitCalculateAgeAt(CalculateAgeAt elm, C context) {
        return null;
    }
}

