/*
 * Decompiled with CFR 0.152.
 */
package info.androidhive.barcode;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.content.res.TypedArray;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.MultiProcessor;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import info.androidhive.barcode.BarcodeGraphic;
import info.androidhive.barcode.BarcodeGraphicTracker;
import info.androidhive.barcode.BarcodeTrackerFactory;
import info.androidhive.barcode.R;
import info.androidhive.barcode.camera.CameraSource;
import info.androidhive.barcode.camera.CameraSourcePreview;
import info.androidhive.barcode.camera.GraphicOverlay;
import java.io.IOException;
import java.util.List;

public class BarcodeReader
extends Fragment
implements View.OnTouchListener,
BarcodeGraphicTracker.BarcodeGraphicTrackerListener {
    private static final String TAG = BarcodeReader.class.getSimpleName();
    private static final int RC_HANDLE_GMS = 9001;
    private static final int RC_HANDLE_CAMERA_PERM = 2;
    private boolean autoFocus = false;
    private boolean useFlash = false;
    private String beepSoundFile;
    public static final String BarcodeObject = "Barcode";
    private boolean isPaused = false;
    private CameraSource mCameraSource;
    private CameraSourcePreview mPreview;
    private GraphicOverlay<BarcodeGraphic> mGraphicOverlay;
    private ScaleGestureDetector scaleGestureDetector;
    private GestureDetector gestureDetector;
    private BarcodeReaderListener mListener;

    public void setBeepSoundFile(String fileName) {
        this.beepSoundFile = fileName;
    }

    public void pauseScanning() {
        this.isPaused = true;
    }

    public void resumeScanning() {
        this.isPaused = false;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_barcode_reader, container, false);
        this.mPreview = (CameraSourcePreview)view.findViewById(R.id.preview);
        this.mGraphicOverlay = (GraphicOverlay)view.findViewById(R.id.graphicOverlay);
        int rc = ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA");
        if (rc == 0) {
            this.createCameraSource(this.autoFocus, this.useFlash);
        } else {
            this.requestCameraPermission(view);
        }
        this.gestureDetector = new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new CaptureGestureListener());
        this.scaleGestureDetector = new ScaleGestureDetector((Context)this.getActivity(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        view.setOnTouchListener((View.OnTouchListener)this);
        return view;
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BarcodeReader);
        this.autoFocus = a.getBoolean(R.styleable.BarcodeReader_auto_focus, true);
        this.useFlash = a.getBoolean(R.styleable.BarcodeReader_use_flash, false);
        a.recycle();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof BarcodeReaderListener)) {
            throw new RuntimeException(context.toString() + " must implement BarcodeReaderListener");
        }
        this.mListener = (BarcodeReaderListener)context;
    }

    private void requestCameraPermission(View view) {
        Log.w((String)TAG, (String)"Camera permission is not granted. Requesting permission");
        String[] permissions = new String[]{"android.permission.CAMERA"};
        if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.CAMERA")) {
            ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])permissions, (int)2);
            return;
        }
        FragmentActivity thisActivity = this.getActivity();
        View.OnClickListener listener = new View.OnClickListener((Activity)thisActivity, permissions){
            final /* synthetic */ Activity val$thisActivity;
            final /* synthetic */ String[] val$permissions;
            {
                this.val$thisActivity = activity;
                this.val$permissions = stringArray;
            }

            public void onClick(View view) {
                ActivityCompat.requestPermissions((Activity)this.val$thisActivity, (String[])this.val$permissions, (int)2);
            }
        };
        view.findViewById(R.id.topLayout).setOnClickListener(listener);
    }

    @SuppressLint(value={"InlinedApi"})
    private void createCameraSource(boolean autoFocus, boolean useFlash) {
        FragmentActivity context = this.getActivity();
        BarcodeDetector barcodeDetector = new BarcodeDetector.Builder((Context)context).build();
        BarcodeTrackerFactory barcodeFactory = new BarcodeTrackerFactory(this.mGraphicOverlay, this);
        barcodeDetector.setProcessor((Detector.Processor)new MultiProcessor.Builder((MultiProcessor.Factory)barcodeFactory).build());
        if (!barcodeDetector.isOperational()) {
            boolean hasLowStorage;
            Log.w((String)TAG, (String)"Detector dependencies are not yet available.");
            IntentFilter lowstorageFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
            boolean bl = hasLowStorage = this.getActivity().registerReceiver(null, lowstorageFilter) != null;
            if (hasLowStorage) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.low_storage_error, (int)1).show();
                Log.w((String)TAG, (String)this.getString(R.string.low_storage_error));
            }
        }
        CameraSource.Builder builder = new CameraSource.Builder((Context)this.getActivity(), (Detector<?>)barcodeDetector).setFacing(0).setRequestedPreviewSize(1600, 1024).setRequestedFps(15.0f);
        if (Build.VERSION.SDK_INT >= 14) {
            builder = builder.setFocusMode(autoFocus ? "continuous-picture" : null);
        }
        this.mCameraSource = builder.setFlashMode(useFlash ? "torch" : null).build();
    }

    public void onResume() {
        super.onResume();
        this.startCameraSource();
    }

    public void onPause() {
        super.onPause();
        if (this.mPreview != null) {
            this.mPreview.stop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPreview != null) {
            this.mPreview.release();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 2) {
            Log.d((String)TAG, (String)("Got unexpected permission result: " + requestCode));
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            return;
        }
        if (grantResults.length != 0 && grantResults[0] == 0) {
            Log.d((String)TAG, (String)"Camera permission granted - initialize the camera source");
            this.createCameraSource(this.autoFocus, this.useFlash);
            return;
        }
        Log.e((String)TAG, (String)("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)")));
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle((CharSequence)"Multitracker sample").setMessage(R.string.no_camera_permission).setPositiveButton(R.string.ok, listener).show();
    }

    private void startCameraSource() throws SecurityException {
        int code = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)this.getActivity());
        if (code != 0) {
            Dialog dlg = GoogleApiAvailability.getInstance().getErrorDialog((Activity)this.getActivity(), code, 9001);
            dlg.show();
        }
        if (this.mCameraSource != null) {
            try {
                this.mPreview.start(this.mCameraSource, this.mGraphicOverlay);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to start camera source.", (Throwable)e);
                this.mCameraSource.release();
                this.mCameraSource = null;
            }
        }
    }

    private boolean onTap(float rawX, float rawY) {
        int[] location = new int[2];
        this.mGraphicOverlay.getLocationOnScreen(location);
        float x = (rawX - (float)location[0]) / this.mGraphicOverlay.getWidthScaleFactor();
        float y = (rawY - (float)location[1]) / this.mGraphicOverlay.getHeightScaleFactor();
        Barcode best = null;
        float bestDistance = Float.MAX_VALUE;
        for (BarcodeGraphic graphic : this.mGraphicOverlay.getGraphics()) {
            float dy;
            Barcode barcode = graphic.getBarcode();
            if (barcode.getBoundingBox().contains((int)x, (int)y)) {
                best = barcode;
                break;
            }
            float dx = x - (float)barcode.getBoundingBox().centerX();
            float distance = dx * dx + (dy = y - (float)barcode.getBoundingBox().centerY()) * dy;
            if (!(distance < bestDistance)) continue;
            best = barcode;
            bestDistance = distance;
        }
        if (best != null) {
            Intent data = new Intent();
            data.putExtra(BarcodeObject, best);
            this.getActivity().setResult(0, data);
            this.getActivity().finish();
            return true;
        }
        return false;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean b = this.scaleGestureDetector.onTouchEvent(motionEvent);
        boolean c = this.gestureDetector.onTouchEvent(motionEvent);
        return b || c || view.onTouchEvent(motionEvent);
    }

    @Override
    public void onScanned(Barcode barcode) {
        if (this.mListener != null && !this.isPaused) {
            this.mListener.onScanned(barcode);
        }
    }

    @Override
    public void onScannedMultiple(List<Barcode> barcodes) {
        if (this.mListener != null && !this.isPaused) {
            this.mListener.onScannedMultiple(barcodes);
        }
    }

    @Override
    public void onBitmapScanned(SparseArray<Barcode> sparseArray) {
        if (this.mListener != null) {
            this.mListener.onBitmapScanned(sparseArray);
        }
    }

    @Override
    public void onScanError(String errorMessage) {
        if (this.mListener != null) {
            this.mListener.onScanError(errorMessage);
        }
    }

    public void playBeep() {
        MediaPlayer m = new MediaPlayer();
        try {
            if (m.isPlaying()) {
                m.stop();
                m.release();
                m = new MediaPlayer();
            }
            AssetFileDescriptor descriptor = this.getActivity().getAssets().openFd(this.beepSoundFile != null ? this.beepSoundFile : "beep.mp3");
            m.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
            descriptor.close();
            m.prepare();
            m.setVolume(1.0f, 1.0f);
            m.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface BarcodeReaderListener {
        public void onScanned(Barcode var1);

        public void onScannedMultiple(List<Barcode> var1);

        public void onBitmapScanned(SparseArray<Barcode> var1);

        public void onScanError(String var1);
    }

    private class ScaleListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            BarcodeReader.this.mCameraSource.doZoom(detector.getScaleFactor());
        }
    }

    private class CaptureGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private CaptureGestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return BarcodeReader.this.onTap(e.getRawX(), e.getRawY()) || super.onSingleTapConfirmed(e);
        }
    }
}

