/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class ScreenWakeLock {
    private UI ui;

    private ScreenWakeLock(UI ui) {
        this.ui = ui;
    }

    public static CompletableFuture<State> request(UI ui, Runnable onReleased) {
        boolean hasReleaseListener;
        boolean bl = hasReleaseListener = onReleased != null;
        if (hasReleaseListener) {
            AtomicReference<DomListenerRegistration> registrationRef = new AtomicReference<DomListenerRegistration>();
            DomListenerRegistration domListenerRegistration = ui.getElement().addEventListener("wake-lock-released", (DomEventListener & Serializable)e -> {
                ((DomListenerRegistration)registrationRef.get()).remove();
                onReleased.run();
            });
            registrationRef.set(domListenerRegistration);
        }
        return ui.getElement().executeJs("    const hasReleaseListener = $0;\n    const uiElement = this;\n    // create an async function to request a wake lock\n    try {\n      window._viritin_wakeLock = await navigator.wakeLock.request(\"screen\");\n        if(hasReleaseListener) {\n            window._viritin_wakeLock.addEventListener('release', () => {\n                const evt = new CustomEvent('wake-lock-released');\n                uiElement.dispatchEvent(evt);\n            });\n        }\n      return \"active\";\n    } catch (err) {\n        return `${err.name}, ${err.message}`;\n    }\n", new Serializable[]{Boolean.valueOf(hasReleaseListener)}).toCompletableFuture(String.class).thenApply(str -> {
            if (str.equals("active")) {
                return State.ACTIVE;
            }
            return State.ERROR;
        });
    }

    public static CompletableFuture<State> request(Runnable onReleased) {
        return ScreenWakeLock.request(UI.getCurrent(), onReleased);
    }

    public static CompletableFuture<State> request() {
        return ScreenWakeLock.request(UI.getCurrent(), null);
    }

    public static void release(UI ui) {
        ui.getElement().executeJs("    if(window._viritin_wakeLock) {\n        await window._viritin_wakeLock.release();\n        window._viritin_wakeLock = null;\n    }\n", new Serializable[0]);
    }

    public static void release() {
        ScreenWakeLock.release(UI.getCurrent());
    }

    public static CompletableFuture<State> checkState(UI ui) {
        return ui.getElement().executeJs("    if (!window._viritin_wakeLock) {\n        return \"unknown\";\n    } else if(window._viritin_wakeLock && window._viritin_wakeLock.released === false) {\n        return \"active\";\n    } else {\n        return \"released\";\n    }\n", new Serializable[0]).toCompletableFuture(String.class).thenApply(str -> {
            if (str.equals("active")) {
                return State.ACTIVE;
            }
            if ("unknown".equals(str)) {
                return State.UNKNOWN;
            }
            return State.RELEASED;
        });
    }

    public static CompletionStage<State> checkState() {
        return ScreenWakeLock.checkState(UI.getCurrent());
    }

    public static enum State {
        UNKNOWN,
        ACTIVE,
        RELEASED,
        ERROR;

    }
}

