/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;

public class JsPromise {
    private static final ObjectMapper jackson = new ObjectMapper();

    public static CompletableFuture<String> resolveString(String promiseBody, Serializable ... args) {
        return JsPromise.resolve(promiseBody, String.class, args);
    }

    public static CompletableFuture<String> computeString(String asyncMethodBody, Serializable ... args) {
        return JsPromise.compute(asyncMethodBody, String.class, args);
    }

    public static CompletableFuture<Integer> computeInteger(String asyncMethodBody, Serializable ... args) {
        return JsPromise.compute(asyncMethodBody, Integer.class, args);
    }

    public static CompletableFuture<Double> computeDouble(String asyncMethodBody, Serializable ... args) {
        return JsPromise.compute(asyncMethodBody, Double.class, args);
    }

    public static CompletableFuture<Boolean> computeBoolean(String asyncMethodBody, Serializable ... args) {
        return JsPromise.compute(asyncMethodBody, Boolean.class, args);
    }

    public static CompletableFuture<Boolean> resolveBoolean(String promiseBody, Serializable ... args) {
        return JsPromise.resolve(promiseBody, Boolean.class, args);
    }

    public static CompletableFuture<Integer> resolveInteger(String promiseBody, Serializable ... args) {
        return JsPromise.resolve(promiseBody, Integer.class, args);
    }

    public static CompletableFuture<Double> resolveDouble(String promiseBody, Serializable ... args) {
        return JsPromise.resolve(promiseBody, Double.class, args);
    }

    public static <T> CompletableFuture<T> resolve(String promiseBody, Class<T> returnType, Serializable ... args) {
        CompletableFuture future = new CompletableFuture();
        UI current = UI.getCurrent();
        Element el = current.getElement();
        el.executeJs("const ui = this;\nconst executeAsyncPromise = new Promise((resolve, reject) => {\n    try {\n    %s\n    } catch (error) {\n        reject(error);\n    }\n}).then(val => {\n    if(typeof val === 'object') {\n        return JSON.stringify(val);\n    } else {\n        return val;\n    }\n});\nreturn executeAsyncPromise;\n".formatted(promiseBody), args).then((SerializableConsumer & Serializable)jsonValue -> {
            if (String.class.isAssignableFrom(returnType)) {
                future.complete(jsonValue.asString());
            } else if (Integer.class.isAssignableFrom(returnType)) {
                int number = (int)jsonValue.asNumber();
                future.complete(number);
            } else if (Double.class.isAssignableFrom(returnType)) {
                double number = jsonValue.asNumber();
                future.complete(number);
            } else if (Boolean.class.isAssignableFrom(returnType)) {
                boolean b = jsonValue.asBoolean();
                future.complete(b);
            } else {
                try {
                    future.complete(jackson.readValue(jsonValue.asString(), returnType));
                }
                catch (JsonProcessingException ex) {
                    future.completeExceptionally(ex);
                }
            }
        }, (SerializableConsumer & Serializable)error -> future.completeExceptionally(new RuntimeException((String)error)));
        return future;
    }

    public static <T> CompletableFuture<T> compute(String asyncMethodBody, Class<T> returnType, Serializable ... args) {
        CompletableFuture future = new CompletableFuture();
        UI current = UI.getCurrent();
        Element el = current.getElement();
        el.executeJs("return (async () => {\n    %s\n}).apply(this, arguments).then(val => {\n    if(typeof val === 'object') {\n        return JSON.stringify(val);\n    } else {\n        return val;\n    }\n});\n".formatted(asyncMethodBody), args).then((SerializableConsumer & Serializable)jsonValue -> {
            if (String.class.isAssignableFrom(returnType)) {
                future.complete(jsonValue.asString());
            } else if (Integer.class.isAssignableFrom(returnType)) {
                int number = (int)jsonValue.asNumber();
                future.complete(number);
            } else if (Double.class.isAssignableFrom(returnType)) {
                double number = jsonValue.asNumber();
                future.complete(number);
            } else if (Boolean.class.isAssignableFrom(returnType)) {
                boolean b = jsonValue.asBoolean();
                future.complete(b);
            } else {
                try {
                    future.complete(jackson.readValue(jsonValue.asString(), returnType));
                }
                catch (JsonProcessingException ex) {
                    future.completeExceptionally(ex);
                }
            }
        }, (SerializableConsumer & Serializable)error -> future.completeExceptionally(new RuntimeException((String)error)));
        return future;
    }
}

