/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.FieldSet;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.textfield.IntegerField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.vaadin.firitin.components.checkbox.VCheckBox;
import org.vaadin.firitin.components.customfield.VCustomField;
import org.vaadin.firitin.components.datepicker.VDatePicker;
import org.vaadin.firitin.components.datetimepicker.VDateTimePicker;
import org.vaadin.firitin.components.textfield.VBigDecimalField;
import org.vaadin.firitin.components.textfield.VIntegerField;
import org.vaadin.firitin.components.textfield.VNumberField;
import org.vaadin.firitin.components.textfield.VTextArea;
import org.vaadin.firitin.components.textfield.VTextField;
import org.vaadin.firitin.components.timepicker.VTimePicker;
import org.vaadin.firitin.fields.ElementCollectionField;
import org.vaadin.firitin.fields.EnumSelect;
import org.vaadin.firitin.fields.LongField;
import org.vaadin.firitin.fields.ShortField;
import org.vaadin.firitin.rad.AutoForm;
import org.vaadin.firitin.rad.PropertyContext;
import org.vaadin.firitin.rad.PropertyHeaderPrinter;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.util.VStyleUtil;

public class AutoFormContext {
    static final ObjectMapper jack = new ObjectMapper();
    static List<PropertyPrinter> _defaultPropertyPrinters = new ArrayList<PropertyPrinter>();
    private final List<PropertyPrinter> propertyEditors;
    private final List<PropertyHeaderPrinter> propertyHeaderPrinters;
    private Locale locale;
    private Set<String> hiddenProperties = new HashSet<String>(){
        {
            this.add("id");
        }
    };
    private boolean annotateTypes = false;
    private boolean defaultBeanValidation = true;

    public AutoFormContext() {
        this(new ArrayList<PropertyPrinter>(AutoFormContext.getDefaultPropertyPrinters()));
    }

    public AutoFormContext(List<PropertyPrinter> propertyPrinters) {
        this.propertyEditors = new ArrayList<PropertyPrinter>(propertyPrinters);
        this.propertyHeaderPrinters = new ArrayList<PropertyHeaderPrinter>();
    }

    public static List<PropertyPrinter> getDefaultPropertyPrinters() {
        if (_defaultPropertyPrinters.isEmpty()) {
            _defaultPropertyPrinters.add(new StringEditor());
            _defaultPropertyPrinters.add(new TypeBasePrinter(VIntegerField.class, Integer.TYPE, Integer.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(LongField.class, Long.class, Long.TYPE));
            _defaultPropertyPrinters.add(new TypeBasePrinter(ShortField.class, Short.class, Short.TYPE));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VNumberField.class, Double.TYPE, Double.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VBigDecimalField.class, BigDecimal.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VDatePicker.class, Date.class, LocalDate.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VDateTimePicker.class, Date.class, LocalDateTime.class, Instant.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VTimePicker.class, LocalTime.class));
            _defaultPropertyPrinters.add(new TypeBasePrinter(VCheckBox.class, Boolean.class, Boolean.TYPE));
            _defaultPropertyPrinters.add(new TypeBasePrinter(EnumSelect.class, Enum.class));
            _defaultPropertyPrinters.add(new EnumSelectPrinter());
            _defaultPropertyPrinters.add(new ElementCollectionPrinter());
            _defaultPropertyPrinters.add(new EmbeddablePrinter());
            _defaultPropertyPrinters.add(new ObjectPrinter());
        }
        return Collections.unmodifiableList(_defaultPropertyPrinters);
    }

    static BasicBeanDescription inrospect(Object dto) {
        if (dto == null) {
            return null;
        }
        Class<?> type = dto.getClass();
        return AutoFormContext.introspectClass(type);
    }

    static BasicBeanDescription introspectClass(Class<?> type) {
        JavaType javaType = jack.getTypeFactory().constructType(type);
        return (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
    }

    public boolean isAnnotateTypes() {
        return this.annotateTypes;
    }

    public void setAnnotateTypes(boolean annotateTypes) {
        this.annotateTypes = annotateTypes;
    }

    public List<PropertyPrinter> getPropertyPrinters() {
        return this.propertyEditors;
    }

    public <T> AutoForm<T> createForm(T value) {
        AutoForm<T> dtoDisplay = new AutoForm<T>(this, AutoFormContext.inrospect(value), value);
        this.propertyHeaderPrinters.forEach(dtoDisplay::withPropertyHeaderPrinter);
        return dtoDisplay;
    }

    public <T> AutoForm<T> createForm(Class<T> type) {
        AutoForm<Object> dtoDisplay = new AutoForm<Object>(this, AutoFormContext.introspectClass(type), null);
        this.propertyHeaderPrinters.forEach(dtoDisplay::withPropertyHeaderPrinter);
        return dtoDisplay;
    }

    public AutoFormContext withPropertyEditor(Class<?> propertyType, Class<? extends HasValue> editorType) {
        return this.withPropertyEditor(new TypeBasePrinter(editorType, propertyType));
    }

    public AutoFormContext withPropertyEditor(PropertyPrinter propertyEditor) {
        this.propertyEditors.add(0, propertyEditor);
        return this;
    }

    public AutoFormContext withPropertyHeaderPrinter(PropertyHeaderPrinter printer) {
        this.propertyHeaderPrinters.add(0, printer);
        return this;
    }

    public AutoFormContext disableBeanValidation() {
        this.defaultBeanValidation = false;
        return this;
    }

    public boolean isDefaultBeanValidation() {
        return this.defaultBeanValidation;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            UI ui = UI.getCurrent();
            this.locale = ui != null ? ui.getLocale() : Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Set<String> getHiddenProperties() {
        return this.hiddenProperties;
    }

    private static class StringEditor
    implements PropertyPrinter {
        private StringEditor() {
        }

        @Override
        public Object printValue(PropertyContext ctx) {
            if (String.class == ctx.beanPropertyDefinition().getPrimaryType().getRawClass()) {
                if (ctx.getName().toString().equals("description")) {
                    return new VTextArea();
                }
                return new VTextField();
            }
            return null;
        }
    }

    private static class TypeBasePrinter
    implements PropertyPrinter {
        private final List<Class> propertyType;
        private final Class<? extends HasValue> componentType;

        public TypeBasePrinter(Class componentType, Class ... propertyType) {
            this.propertyType = Arrays.asList(propertyType);
            this.componentType = componentType;
        }

        public Component printValue(PropertyContext ctx) {
            Class rawClass = ctx.beanPropertyDefinition().getPrimaryType().getRawClass();
            if (this.propertyType.contains(rawClass)) {
                try {
                    return (Component)this.componentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    private static class EnumSelectPrinter
    implements PropertyPrinter {
        private EnumSelectPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().getRawClass().isEnum()) {
                return new EnumSelect(ctx.beanPropertyDefinition().getPrimaryType().getRawClass());
            }
            return null;
        }
    }

    private static class ElementCollectionPrinter
    implements PropertyPrinter {
        private ElementCollectionPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isCollectionLikeType()) {
                JavaType primaryType = ctx.beanPropertyDefinition().getPrimaryType();
                JavaType javaType = primaryType.containedType(0);
                Class rawClass = javaType.getRawClass();
                return new ElementCollectionField(rawClass);
            }
            return null;
        }
    }

    private static class EmbeddablePrinter
    implements PropertyPrinter {
        private EmbeddablePrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isRecordType()) {
                AutoForm owner = (AutoForm)ctx.owner();
                AutoFormContext autoFormContext = owner.getAutoFormContext();
                AutoForm form = autoFormContext.createForm(ctx.beanPropertyDefinition().getPrimaryType().getRawClass());
                return new RecordField(form);
            }
            return null;
        }

        private static class RecordField<T>
        extends VCustomField<T> {
            private final AutoForm<T> form;

            public RecordField(AutoForm<T> form) {
                super(null);
                this.form = form;
                this.addClassNames(new String[]{"full-width", "v-record-field"});
                VStyleUtil.injectAsFirst("        .v-record-field fieldset  {\n            padding: 0 var(--lumo-space-m);\n            border: 1px dashed var(--lumo-contrast-30pct);\n            border-radius: var(--lumo-border-radius-l);\n        }\n");
                FieldSet fieldSet = new FieldSet();
                this.add(new Component[]{fieldSet});
                fieldSet.add(new Component[]{form});
                form.getBinder().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                    if (e.isFromClient()) {
                        this.setModelValue(e.getValue(), true);
                    }
                });
            }

            protected T generateModelValue() {
                return this.form.getValue();
            }

            protected void setPresentationValue(T newPresentationValue) {
                this.form.getBinder().setValue(newPresentationValue);
            }
        }
    }

    private static class ObjectPrinter
    implements PropertyPrinter {
        private ObjectPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            String msg = "Editing " + ctx.getName() + " not supported. Type: " + String.valueOf(ctx.beanPropertyDefinition().getPrimaryType());
            return new Paragraph(msg);
        }
    }

    private static class BooleanEditor
    implements PropertyPrinter {
        private BooleanEditor() {
        }

        public Component printValue(PropertyContext ctx) {
            if (Boolean.class == ctx.beanPropertyDefinition().getPrimaryType().getRawClass() || Boolean.TYPE == ctx.beanPropertyDefinition().getPrimaryType().getRawClass()) {
                return new Checkbox();
            }
            return null;
        }
    }

    private static class IntegerEditor
    implements PropertyPrinter {
        private IntegerEditor() {
        }

        public Component printValue(PropertyContext ctx) {
            if (Integer.class == ctx.beanPropertyDefinition().getPrimaryType().getRawClass() || Integer.TYPE == ctx.beanPropertyDefinition().getPrimaryType().getRawClass()) {
                return new IntegerField();
            }
            return null;
        }
    }

    private static class ComboBoxPrinter
    implements PropertyPrinter {
        private ComboBoxPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            return new ComboBox();
        }
    }
}

