/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.badge;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.util.Optional;

@Tag(value="viritin-badge")
@StyleSheet(value="context://frontend/org/vaadin/firitin/components/badge.css")
public class Badge
extends Span {
    public Badge withTheme(Theme ... themes) {
        for (Theme theme : themes) {
            this.addClassName(theme.name().toLowerCase());
        }
        return this;
    }

    public Badge withIcon(VaadinIcon vaadinIcon) {
        Icon icon = vaadinIcon.create();
        icon.getStyle().setPadding("var(--lumo-space-xs)");
        this.add(new Component[]{icon});
        return this;
    }

    public Badge() {
    }

    public Badge(String text) {
        this();
        this.add(new Component[]{new Span(text)});
    }

    public void setText(String text) {
        this.getSpan().ifPresent(s -> this.remove(new Component[]{s}));
        this.add(new Component[]{new Span(text)});
    }

    private Optional<Span> getSpan() {
        return this.getChildren().filter(c -> c instanceof Span).findFirst().map(c -> (Span)c);
    }

    public String getText() {
        return this.getSpan().orElseGet(Span::new).getText();
    }

    public static enum Theme {
        SUCCESS,
        ERROR,
        WARNING,
        CONTRAST,
        PRIMARY,
        SMALL,
        PILL;

    }
}

