/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.firitin.appframework.BasicNavigationItem;
import org.vaadin.firitin.appframework.MenuItem;
import org.vaadin.firitin.appframework.NavigationItem;
import org.vaadin.firitin.appframework.SubMenu;
import org.vaadin.firitin.appframework.VAppLayout;

public abstract class MainLayout
extends VAppLayout {
    private Map<Class<?>, NavigationItem> targetToItem = new HashMap();

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
    }

    protected void init() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forSessionScope();
        routeConfiguration.getAvailableRoutes().stream().filter(routeData -> {
            Class parentLayout = routeData.getParentLayout();
            if (parentLayout == null) {
                parentLayout = routeConfiguration.getHandledRegistry().getLayout(routeConfiguration.getUrl(routeData.getNavigationTarget()));
            }
            if (parentLayout != null) {
                boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                return assignableFrom;
            }
            return false;
        }).forEach(rd -> {
            Class routeClass = rd.getNavigationTarget();
            if (!Modifier.isAbstract(routeClass.getModifiers())) {
                this.addNavigationItem(new BasicNavigationItem(routeClass));
            }
        });
        RouteConfiguration.forApplicationScope().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            try {
                event.getRemovedRoutes().forEach(route -> this.targetToItem.remove(route.getNavigationTarget()));
                this.getUI().ifPresent(ui -> {
                    if (ui.isClosing()) {
                        return;
                    }
                    ui.access((Command & Serializable)() -> {
                        List addedRoutes = event.getAddedRoutes();
                        addedRoutes.stream().filter(routeData -> {
                            Class parentLayout = routeData.getParentLayout();
                            if (parentLayout != null) {
                                boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                                return assignableFrom;
                            }
                            return false;
                        }).forEach(rd -> {
                            Class routeClass = rd.getNavigationTarget();
                            if (!Modifier.isAbstract(routeClass.getModifiers()) && routeClass != null) {
                                this.addNavigationItem(new BasicNavigationItem(routeClass));
                            }
                        });
                        this.buildMenu();
                    });
                });
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error updating routes, happens with latest Vaadin versions & JRebel sometimes", e);
            }
        });
        this.buildMenu();
    }

    private void addNavigationItem(NavigationItem item) {
        MenuItem annotation = item.getNavigationTarget().getAnnotation(MenuItem.class);
        if (annotation != null && annotation.parent() != MenuItem.NO_PARENT) {
            NavigationItem parentItem = this.ensureParentItem(annotation.parent());
            item.setParentItem(parentItem);
        }
        this.targetToItem.put(item.getNavigationTarget(), item);
    }

    private NavigationItem ensureParentItem(Class<?> parent) {
        return this.targetToItem.computeIfAbsent(parent, p -> {
            if (Component.class.isAssignableFrom(parent)) {
                return new BasicNavigationItem(parent);
            }
            return new SubMenu(parent);
        });
    }

    protected void sortMenuItems(List<NavigationItem> navigationItems) {
        Collections.sort(navigationItems, new Comparator<NavigationItem>(){

            @Override
            public int compare(NavigationItem o1, NavigationItem o2) {
                Double order1 = 1.getOrder1(o1);
                Double order2 = 1.getOrder1(o2);
                double d = order1 - order2;
                if (d == 0.0) {
                    return o1.getText().compareTo(o2.getText());
                }
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return o1.getText().compareTo(o2.getText());
            }

            private static Double getOrder1(NavigationItem o1) {
                Menu av1;
                MenuItem a1 = o1.getNavigationTarget().getAnnotation(MenuItem.class);
                Double order1 = a1 != null ? Double.valueOf(a1.order()) : ((av1 = o1.getNavigationTarget().getAnnotation(Menu.class)) != null ? Double.valueOf(av1.order()) : Double.valueOf(1000.0));
                return order1;
            }
        });
    }

    public List<NavigationItem> getNavigationItems() {
        if (this.targetToItem.isEmpty()) {
            this.init();
        }
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>(this.targetToItem.values());
        return navigationItems;
    }

    public void buildMenu() {
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>(this.targetToItem.values().stream().filter(ni -> ni.getParentItem() == null).toList());
        this.sortMenuItems(navigationItems);
        this.getMenu().removeAll();
        navigationItems.stream().filter(this::checkAccess).forEach(item -> {
            this.getMenu().addNavigationItem((NavigationItem)item);
            ArrayList<NavigationItem> subItems = new ArrayList<NavigationItem>(this.targetToItem.values().stream().filter(ni -> ni.getParentItem() == item).toList());
            this.sortMenuItems(subItems);
            subItems.forEach(item::addSubItem);
        });
    }

    protected boolean checkAccess(NavigationItem navigationItem) {
        return true;
    }

    @Override
    protected void afterNavigation() {
        this.updateSelectedNavigationItem();
        super.afterNavigation();
        if (this.targetToItem.isEmpty()) {
            this.init();
        }
    }

    private void updateSelectedNavigationItem() {
        this.getNavigationItems().forEach(i -> i.setActive(i.getNavigationTarget() == this.getContent().getClass()));
    }
}

