/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.button;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class UIFuture {
    private final UI ui;
    private int actions = 0;
    private PushMode pushMode;
    private boolean pollingEnabled;
    private boolean asyncUiUpdate = false;
    private Executor executor;

    public UIFuture(UI ui) {
        this.ui = ui;
    }

    public UIFuture() {
        this(UI.getCurrent());
    }

    public boolean isAsyncUiUpdate() {
        return this.asyncUiUpdate;
    }

    public void setAsyncUiUpdate(boolean asyncUiUpdate) {
        this.asyncUiUpdate = asyncUiUpdate;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private void ensurePushOrPolling() {
        ++this.actions;
        if (this.actions == 1) {
            PushConfiguration pushConfiguration = this.ui.getPushConfiguration();
            this.pushMode = pushConfiguration.getPushMode();
            if (this.pushMode == PushMode.DISABLED && this.ui.getPollInterval() == -1) {
                this.ui.setPollInterval(1000);
                this.pollingEnabled = true;
                Logger.getLogger(UIFuture.class.getName()).fine("Polling enabled by UIFuture. Consider enabling using push instead or enabling polling manually. This may cause timing issues.");
            }
        }
    }

    private void shutDownPolling() {
        --this.actions;
        if (this.pollingEnabled && this.actions == 0) {
            UI.getCurrent().setPollInterval(-1);
            this.pollingEnabled = false;
        }
    }

    public <T> CompletableFuture<T> of(CompletableFuture<T> task) {
        this.ensurePushOrPolling();
        CompletableFuture future = new CompletableFuture();
        BiConsumer<Object, Throwable> handler = (result, throwable) -> this.ui.access((Command & Serializable)() -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(result);
            }
            this.shutDownPolling();
            if (this.pushMode == PushMode.MANUAL) {
                this.ui.push();
            }
        });
        if (this.asyncUiUpdate) {
            if (this.executor != null) {
                task.whenCompleteAsync(handler, this.executor);
            } else {
                task.whenCompleteAsync(handler);
            }
        } else {
            task.whenComplete(handler);
        }
        return future;
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        CompletableFuture<T> future = this.executor != null ? CompletableFuture.supplyAsync(supplier, this.executor) : CompletableFuture.supplyAsync(supplier);
        return this.of(future);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = this.executor != null ? CompletableFuture.runAsync(runnable, this.executor) : CompletableFuture.runAsync(runnable);
        return this.of(future);
    }
}

