/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.router.Menu;
import org.vaadin.firitin.appframework.BasicNavigationItem;
import org.vaadin.firitin.appframework.MainLayout;
import org.vaadin.firitin.appframework.MenuItem;
import org.vaadin.firitin.appframework.NavigationItem;

public class SubMenu
extends MainLayout.AdvancedSideNav
implements NavigationItem {
    private final Class<?> navigationTarget;
    private NavigationItem parentItem;

    public SubMenu(Class<?> navigationTarget) {
        Menu menu;
        this.navigationTarget = navigationTarget;
        String text = NavigationItem.getMenuTextFromClass(navigationTarget);
        this.setLabel(text);
        MenuItem me = navigationTarget.getAnnotation(MenuItem.class);
        if (me != null) {
            if (me.icon() != null) {
                // empty if block
            }
            if (!me.enabled()) {
                throw new IllegalArgumentException("SubMenu don't yet support disabling");
            }
            this.setCollapsible(me.collapsible());
            this.setExpanded(me.openByDefault());
        } else if (navigationTarget.isAnnotationPresent(Menu.class) && (menu = navigationTarget.getAnnotation(Menu.class)).icon() != null) {
            throw new IllegalArgumentException("SubMenu don't yet support an icon");
        }
    }

    @Override
    public String getText() {
        return this.getLabel();
    }

    @Override
    public Class<?> getNavigationTarget() {
        return this.navigationTarget;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public void addSubItem(NavigationItem item) {
        if (item instanceof SubMenu) {
            this.addSubMenu((SubMenu)item);
        } else {
            this.addItem(new SideNavItem[]{(BasicNavigationItem)item});
            item.getStyle().setPaddingLeft("var(--lumo-space-l)");
        }
    }

    @Override
    public void setParentItem(NavigationItem parent) {
        this.parentItem = parent;
    }

    @Override
    public NavigationItem getParentItem() {
        return this.parentItem;
    }
}

