/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.layouts;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import java.util.HashMap;
import java.util.Map;

@Tag(value="border-layout")
@JsModule(value="./org/vaadin/firitin/layouts/border-layout.js")
public class BorderLayout
extends Component
implements HasComponents {
    private final Map<Region, Component> children = new HashMap<Region, Component>(Region.values().length);

    private static void applyStyle(Component component, Region region) {
        BorderLayout.stripStyle(component);
        component.getElement().getClassList().add((Object)region.name().toLowerCase());
    }

    private static void stripStyle(Component component) {
        for (Region region : Region.values()) {
            component.getElement().getClassList().remove((Object)region.name().toLowerCase());
        }
    }

    public void setChildAt(Region region, Component component) {
        Component existingChild = this.children.get((Object)region);
        if (existingChild != null) {
            this.remove(new Component[]{existingChild});
        }
        BorderLayout.applyStyle(component, region);
        this.add(new Component[]{component});
        this.children.put(region, component);
    }

    public void removeChildAt(Region region) {
        Component existingChild = this.children.get((Object)region);
        if (existingChild == null) {
            return;
        }
        BorderLayout.stripStyle(existingChild);
        this.remove(new Component[]{existingChild});
        this.children.remove((Object)region);
    }

    public static enum Region {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        CENTER;

    }
}

