/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class SubListSelector<T>
extends Composite<VerticalLayout>
implements HasValue<HasValue.ValueChangeEvent<List<T>>, List<T>>,
HasSize {
    private final Class<T> clazz;
    private List<T> availableOptions;
    private List<T> value;
    protected ComboBox<T> addToSelectionCb = new ComboBox();
    protected Grid<T> grid;

    public SubListSelector(Class<T> clazz) {
        this.clazz = clazz;
        this.grid = new Grid(clazz);
        this.configureGridColumns();
        this.addDeleteButtonColumn();
        this.addToSelectionCb.setPlaceholder("add entry to selection...");
        this.addToSelectionCb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            Object newValue = e.getValue();
            if (newValue != null) {
                this.addToSelection(newValue);
            }
        });
        this.addToSelectionCb.setAllowCustomValue(true);
        this.addToSelectionCb.addCustomValueSetListener((ComponentEventListener & Serializable)e -> {
            Object newInstance = this.createValueFromString(e.getDetail());
            if (newInstance != null) {
                this.availableOptions.add(newInstance);
                this.addToSelection(newInstance);
            }
        });
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.addToSelectionCb, this.grid});
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.addToSelectionCb.setItemLabelGenerator(itemLabelGenerator);
    }

    protected T createValueFromString(String detail) {
        try {
            Constructor<T> constructor = this.clazz.getConstructor(String.class);
            return constructor.newInstance(detail);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addToSelection(T newValue) {
        this.value.add(newValue);
        this.grid.setItems(this.value);
        this.fireValueChange();
        this.addToSelectionCb.setValue(null);
        this.adjustAvailableItemsInCombobox();
    }

    protected void configureGridColumns() {
    }

    protected void addDeleteButtonColumn() {
        this.grid.addComponentColumn((ValueProvider & Serializable)t -> new Button("Remove", (ComponentEventListener & Serializable)e -> {
            this.value.remove(t);
            this.grid.setItems(this.value);
            this.adjustAvailableItemsInCombobox();
            this.fireValueChange();
        }));
    }

    private void fireValueChange() {
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
    }

    public void setAvailableOptions(List<T> options) {
        this.availableOptions = options;
        this.adjustAvailableItemsInCombobox();
    }

    private void adjustAvailableItemsInCombobox() {
        ArrayList<T> list = new ArrayList<T>(this.availableOptions);
        if (this.value != null) {
            list.removeAll(this.value);
        }
        this.addToSelectionCb.setItems(list);
    }

    public void setValue(List<T> value) {
        this.value = value;
        this.grid.setItems(this.value);
        this.adjustAvailableItemsInCombobox();
    }

    public List<T> getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<List<T>>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged((HasValue.ValueChangeEvent)valueChangeEvent);
        };
        return this.addListener(AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }
}

