/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.textfield.TextArea;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StringToDoubleMapField
extends AbstractCompositeField<TextArea, StringToDoubleMapField, Map<String, Double>>
implements HasSize {
    private Map<String, Double> oldValue;

    public StringToDoubleMapField() {
        super(Collections.emptyMap());
        ((TextArea)this.getContent()).addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, this.oldValue, e.isFromClient())));
    }

    public StringToDoubleMapField(String label) {
        this();
        this.setLabel(label);
    }

    public void setValue(Map<String, Double> value) {
        super.setValue(value);
        this.oldValue = value;
    }

    public Map<String, Double> getValue() {
        HashMap<String, Double> set = new HashMap<String, Double>();
        for (String s : ((TextArea)this.getContent()).getValue().split(",\\s*")) {
            String[] parts = s.split("=");
            if (parts.length != 2) continue;
            Double d = Double.parseDouble(parts[1].trim());
            String key = parts[0].trim();
            set.put(key, d);
        }
        return set;
    }

    protected void setPresentationValue(Map<String, Double> newPresentationValue) {
        System.out.println(newPresentationValue);
        ((TextArea)this.getContent()).setValue(newPresentationValue.toString().replaceAll("\\{", "").replaceAll("}", ""));
    }

    public void setLabel(String label) {
        ((TextArea)this.getContent()).setLabel(label);
    }

    public String getLabel() {
        return ((TextArea)this.getContent()).getLabel();
    }
}

