/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasTheme;

public class VGrid<T>
extends Grid<T>
implements FluentComponent<VGrid<T>>,
FluentHasStyle<VGrid<T>>,
FluentHasSize<VGrid<T>>,
FluentFocusable<Grid<T>, VGrid<T>>,
FluentHasTheme<VGrid<T>> {
    public VGrid() {
    }

    public VGrid(int pageSize) {
        super(pageSize);
    }

    public VGrid(Class<T> beanType) {
        super(beanType);
    }

    public VGrid<T> withSelectionMode(Grid.SelectionMode selectionMode) {
        this.setSelectionMode(selectionMode);
        return this;
    }

    public VGrid<T> withSelectionModel(GridSelectionModel<T> selectionModel, Grid.SelectionMode selectionMode) {
        this.setSelectionModel(selectionModel, selectionMode);
        return this;
    }

    public VGrid<T> withProperties(String ... propertyNames) {
        this.setColumns(propertyNames);
        return this;
    }

    public VGrid<T> withThemeVariants(GridVariant ... variants) {
        this.addThemeVariants(variants);
        return this;
    }

    public VGrid<T> setDataProvider(CallbackDataProvider.FetchCallback<T, Void> fetchCallback, CallbackDataProvider.CountCallback<T, Void> countCallback) {
        this.setDataProvider((DataProvider)DataProvider.fromCallbacks(fetchCallback, countCallback));
        return this;
    }

    public VGrid<T> withItems(Collection<T> items) {
        this.setItems(items);
        return this;
    }

    @Deprecated
    public VGrid<T> withItems(Stream<T> streamOfItems) {
        this.setItems(streamOfItems);
        return this;
    }

    public VGrid<T> withItems(T ... items) {
        this.setItems(items);
        return this;
    }

    @Deprecated
    public void scrollToItem(T item) {
        Stream items;
        try {
            items = this.getListDataView().getItems();
        }
        catch (IllegalStateException exception) {
            items = this.getGenericDataView().getItems();
        }
        AtomicInteger i = new AtomicInteger();
        int index = items.peek(v -> i.incrementAndGet()).anyMatch(itm -> itm.equals(item)) ? i.get() - 1 : -1;
        this.scrollToIndex(index);
    }
}

