/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.data.event.SortEvent;
import java.io.Serializable;
import java.util.List;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.grid.VGrid;
import org.vaadin.firitin.components.orderedlayout.VHorizontalLayout;

public class PagingGrid<T>
extends VGrid<T> {
    private PagingDataProvider<T> dataProvider;
    private PaginationBar paginationBar;
    private ComponentEventListener<SortEvent<Grid<T>, GridSortOrder<T>>> sortListener = (ComponentEventListener & Serializable)event -> this.setItems(this.dataProvider.pageRequested(this.paginationBar.currentPage, this.getPageSize()));

    public PagingGrid() {
        this.init();
    }

    private void init() {
        this.addSortListener(this.sortListener);
        this.setHeightByRows(true);
        this.setPageSize(10);
    }

    public PagingGrid(Class<T> beanType) {
        super(beanType);
        this.init();
    }

    public PagingGrid(int pageSize) {
        super(pageSize);
        this.init();
    }

    private void preparePaginationBar() {
        this.paginationBar = new PaginationBar(null);
        HeaderRow headerRow = this.prependHeaderRow();
        headerRow.join(this.getColumns().toArray(new Grid.Column[0])).setComponent((Component)this.paginationBar);
    }

    public PagingDataProvider<T> getPagingDataProvider() {
        return this.dataProvider;
    }

    public void setPagingDataProvider(PagingDataProvider<T> provider) {
        this.dataProvider = provider;
        this.preparePaginationBar();
        this.setItems(this.dataProvider.pageRequested(0L, this.getPageSize()));
    }

    public void setTotalResults(long totalResults) {
        this.paginationBar.setSize(totalResults);
        this.paginationBar.updateState();
    }

    class PaginationBar
    extends VHorizontalLayout {
        private static final long serialVersionUID = 7799263034212965499L;
        private Long size;
        private long currentPage;
        private Long pages;
        private Button first;
        private Button last;
        private Button next;
        private Button previous;
        private final Span status = new Span();
        private VHorizontalLayout pageBtns = new VHorizontalLayout();

        private void updateState() {
            boolean hasPrev = this.currentPage > 0L;
            this.first.setEnabled(hasPrev);
            this.previous.setEnabled(hasPrev);
            if (this.sizeKnown()) {
                long end;
                long start;
                boolean hasNext = this.currentPage < this.pages - 1L;
                this.last.setVisible(true);
                this.last.setEnabled(hasNext);
                this.next.setEnabled(hasNext);
                this.pageBtns.removeAll();
                if (this.pages < 10L) {
                    start = 0L;
                    end = this.pages;
                } else {
                    start = this.currentPage - 4L;
                    if (start < 0L) {
                        start = 0L;
                    }
                    if ((end = start + 9L) > this.pages) {
                        end = this.pages;
                    }
                    if (end - start < 10L) {
                        start = end - 9L;
                    }
                }
                for (long i = start; i < end; ++i) {
                    long finalI = i;
                    VButton btn = (VButton)new VButton("" + (i + 1L), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
                        this.currentPage = finalI;
                        this.fetchPage();
                    }).withEnabled(this.currentPage != i);
                    btn.withThemeVariants(ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_SMALL);
                    this.pageBtns.add(new Component[]{btn});
                }
                this.status.setVisible(false);
                this.pageBtns.setVisible(true);
            } else {
                this.last.setEnabled(false);
                this.next.setEnabled(true);
                this.status.setText("Page " + (this.currentPage + 1L) + ", showing " + PagingGrid.this.getPageSize() + " results per page.");
                this.pageBtns.setVisible(false);
            }
        }

        private void initButtons() {
            this.first = new VButton((Component)VaadinIcon.FAST_BACKWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.last = new VButton((Component)VaadinIcon.FAST_FORWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.next = new VButton((Component)VaadinIcon.FORWARD.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
            this.previous = new VButton((Component)VaadinIcon.BACKWARDS.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> this.handleClick((ClickEvent<Button>)e));
        }

        private void handleClick(ClickEvent<Button> event) {
            if (event.getSource() == this.first) {
                this.currentPage = 0L;
            } else if (event.getSource() == this.last) {
                this.currentPage = this.pages - 1L;
            } else if (event.getSource() == this.next) {
                ++this.currentPage;
            } else if (event.getSource() == this.previous) {
                --this.currentPage;
            }
            this.fetchPage();
        }

        private void fetchPage() {
            List page = PagingGrid.this.dataProvider.pageRequested(this.currentPage, PagingGrid.this.getPageSize());
            if (page.size() > 0) {
                PagingGrid.this.setItems(page);
                if (page.size() < PagingGrid.this.getPageSize()) {
                    this.setSize((long)page.size() + this.currentPage * (long)PagingGrid.this.getPageSize());
                }
            } else {
                this.setSize(this.currentPage * (long)PagingGrid.this.getPageSize());
                if (this.currentPage > 0L) {
                    --this.currentPage;
                }
            }
            this.updateState();
        }

        public long getSize() {
            return this.size;
        }

        public PaginationBar(Long size) {
            this.setSize(size);
            this.initButtons();
            this.updateState();
            this.add(new Component[]{this.first, this.previous});
            ((VHorizontalLayout)this.space().withComponents(new Component[]{this.pageBtns, this.status})).space();
            this.add(new Component[]{this.next, this.last});
            this.alignAll(FlexComponent.Alignment.CENTER);
            this.withFullWidth();
        }

        void setSize(Long s) {
            this.size = s;
            if (this.sizeKnown()) {
                this.pages = (long)Math.ceil(1.0 * (double)this.size.longValue() / (double)PagingGrid.this.getPageSize());
            }
        }

        private boolean sizeKnown() {
            return this.size != null;
        }
    }

    public static interface PagingDataProvider<T> {
        public List<T> pageRequested(long var1, int var3);
    }
}

