/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.datetimepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasHelper;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasTooltip;
import org.vaadin.firitin.fluency.ui.FluentHasValidation;
import org.vaadin.firitin.fluency.ui.FluentHasValueAndElement;
import org.vaadin.firitin.fluency.ui.FluentThemableLayout;

public class VDateTimePicker
extends DateTimePicker
implements FluentHasSize<VDateTimePicker>,
FluentHasValidation<VDateTimePicker>,
FluentHasStyle<VDateTimePicker>,
FluentFocusable<DateTimePicker, VDateTimePicker>,
FluentComponent<VDateTimePicker>,
FluentThemableLayout<VDateTimePicker>,
FluentHasValueAndElement<VDateTimePicker, AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>, LocalDateTime>,
FluentHasHelper<VDateTimePicker>,
FluentHasTooltip<VDateTimePicker> {
    private static HashMap<Locale, DatePicker.DatePickerI18n> i18nCache = new HashMap();

    public VDateTimePicker() {
        this.initI18n();
    }

    public VDateTimePicker(String label) {
        super(label);
        this.initI18n();
    }

    public VDateTimePicker(String label, LocalDateTime initialDateTime) {
        super(label, initialDateTime);
        this.initI18n();
    }

    public VDateTimePicker(LocalDateTime initialDateTime) {
        super(initialDateTime);
        this.initI18n();
    }

    public VDateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(listener);
        this.initI18n();
    }

    public VDateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(label, listener);
        this.initI18n();
    }

    public VDateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(initialDateTime, listener);
        this.initI18n();
    }

    public VDateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(label, initialDateTime, listener);
        this.initI18n();
    }

    public VDateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        super(initialDateTime, locale);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.initI18n();
    }

    protected void initI18n() {
        Locale l = this.getLocale();
        if (l != null) {
            DatePicker.DatePickerI18n i18n = VDateTimePicker.createI18nFromLocale(l);
            this.setDatePickerI18n(i18n);
        }
    }

    public static synchronized DatePicker.DatePickerI18n createI18nFromLocale(Locale locale) {
        return i18nCache.computeIfAbsent(locale, l -> {
            DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
            i18n.setFirstDayOfWeek(WeekFields.of(locale).getFirstDayOfWeek().getValue() % 7);
            i18n.setMonthNames(Stream.of(Month.values()).map(m -> m.getDisplayName(TextStyle.FULL_STANDALONE, locale)).collect(Collectors.toList()));
            List weekdays = Stream.of(DayOfWeek.values()).map(d -> d.getDisplayName(TextStyle.FULL_STANDALONE, locale)).collect(Collectors.toList());
            Collections.rotate(weekdays, 1);
            i18n.setWeekdays(weekdays);
            List weekdaysShort = Stream.of(DayOfWeek.values()).map(d -> d.getDisplayName(TextStyle.SHORT_STANDALONE, locale)).collect(Collectors.toList());
            Collections.rotate(weekdaysShort, 1);
            i18n.setWeekdaysShort(weekdaysShort);
            return i18n;
        });
    }

    public VDateTimePicker withDatePlaceholder(String placeholder) {
        this.setDatePlaceholder(placeholder);
        return this;
    }

    public VDateTimePicker withTimePlaceholder(String placeholder) {
        this.setTimePlaceholder(placeholder);
        return this;
    }

    public VDateTimePicker withStep(Duration step) {
        this.setStep(step);
        return this;
    }

    public VDateTimePicker withWeekNumbersVisible(boolean weekNumbersVisible) {
        this.setWeekNumbersVisible(weekNumbersVisible);
        return this;
    }

    public VDateTimePicker withLocale(Locale locale) {
        this.setLocale(locale);
        return this;
    }

    public VDateTimePicker withMin(LocalDateTime min) {
        this.setMin(min);
        return this;
    }

    public VDateTimePicker withMax(LocalDateTime max) {
        this.setMax(max);
        return this;
    }

    public VDateTimePicker withDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        this.setDatePickerI18n(i18n);
        return this;
    }

    @Override
    public VDateTimePicker withRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.setRequiredIndicatorVisible(requiredIndicatorVisible);
        return this;
    }
}

