/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.vaadin.firitin.fluency.ui.FluentComponent;

public class DynamicFileDownloader
extends Anchor
implements FluentComponent<DynamicFileDownloader> {
    private Button button;
    private DomListenerRegistration disableOnclick;
    private final String identifier = UUID.randomUUID().toString();
    private String fileName;
    private SerializableConsumer<OutputStream> contentWriter;
    private List<Runnable> downloadFinishedListener;
    protected RequestHandler requestHandler;

    public void setDisableOnClick(boolean disableOnClick) {
        if (this.disableOnclick != null) {
            this.disableOnclick.remove();
        }
        if (disableOnClick) {
            this.disableOnclick = this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> this.setEnabled(false));
        }
    }

    public DynamicFileDownloader(String text, String fileName, SerializableConsumer<OutputStream> contentWriter) {
        this();
        this.setText(text);
        this.fileName = fileName;
        this.contentWriter = contentWriter;
    }

    public DynamicFileDownloader() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.requestHandler = new RequestHandler(){

                public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
                    if (request.getPathInfo().endsWith(DynamicFileDownloader.this.identifier)) {
                        response.setStatus(200);
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + DynamicFileDownloader.this.getFileName(session, request) + "\"");
                        try {
                            DynamicFileDownloader.this.contentWriter.accept((Object)response.getOutputStream());
                        }
                        catch (Exception e) {
                            try {
                                response.setStatus(500);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            e.printStackTrace();
                            return true;
                        }
                        DynamicFileDownloader.this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadFinishedEvent(DynamicFileDownloader.this, false))));
                        return true;
                    }
                    return false;
                }
            };
            ui.getSession().addRequestHandler(this.requestHandler);
            this.setHref("./" + this.identifier);
            if (this.fileName != null) {
                this.getElement().setAttribute("download", this.fileName);
            } else {
                this.getElement().setAttribute("download", "");
            }
        });
    }

    protected void onDetach(DetachEvent detachEvent) {
        ((UI)this.getUI().get()).getSession().removeRequestHandler(this.requestHandler);
        super.onDetach(detachEvent);
    }

    public Registration addDownloadFinishedListener(ComponentEventListener<DownloadFinishedEvent> listener) {
        return this.addListener(DownloadFinishedEvent.class, listener);
    }

    public void setFileHandler(SerializableConsumer<OutputStream> contentWriter) {
        this.contentWriter = contentWriter;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected String getFileName(VaadinSession session, VaadinRequest request) {
        return this.fileName;
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public DynamicFileDownloader asButton() {
        String text = this.getText();
        this.setText(null);
        this.button = new Button(text);
        this.add(new Component[]{this.button});
        return this;
    }

    public Button getButton() {
        if (this.button == null) {
            throw new IllegalStateException("asButton() is not called!");
        }
        return this.button;
    }

    public static class DownloadFinishedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        public DownloadFinishedEvent(DynamicFileDownloader source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

