/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import com.payu.india.Interfaces.DeleteSavedOptionsListener;
import com.payu.india.Interfaces.FetchAdsInformationApiListener;
import com.payu.india.Interfaces.FetchIFSCDetailsListener;
import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Interfaces.HashGenerationListener;
import com.payu.india.Interfaces.OnEmiCalculaterListener;
import com.payu.india.Interfaces.V2APITaskListener;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.CalculateEmiRequest;
import com.payu.india.Model.DeleteSavedOptionsRequest;
import com.payu.india.Model.DeviceIdRequest;
import com.payu.india.Model.FetchOffer.FetchOfferApiRequest;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.QuickPay.GlobalVaultOTPRequest;
import com.payu.india.Model.QuickPay.GlobalVaultVerifyOTPRequest;
import com.payu.india.Model.QuickPay.QuickPayRequest;
import com.payu.india.Model.adsinformation.AdsApiRequest;
import com.payu.india.Model.adsinformation.AdsImpressionApiRequest;
import com.payu.india.Model.adsinformation.AdsPayUIdApiRequest;
import com.payu.india.Model.validateOffer.ValidateOfferRequest;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.DeleteSavedOptionsTask;
import com.payu.india.Tasks.EmiCalculatorTask;
import com.payu.india.Tasks.FetchAdsInformationTask;
import com.payu.india.Tasks.FetchIFSCDetailsTask;
import com.payu.india.Tasks.FetchOfferDetailsTask;
import com.payu.india.Tasks.GlobalVaultReSendOTPTask;
import com.payu.india.Tasks.GlobalVaultSendOTPTask;
import com.payu.india.Tasks.GlobalVaultVerifyOTPTask;
import com.payu.india.Tasks.QuickPayTask;
import com.payu.india.Tasks.SaveEventImpressionTask;
import com.payu.india.Tasks.UpdateDeviceIdTask;
import com.payu.india.Tasks.UpdatePayUIdTask;
import com.payu.india.Tasks.ValidateOfferTask;
import java.util.HashMap;

public class V2ApiTask
implements V2APITaskListener {
    private String key;
    private PayuConfig payuConfig;
    private QuickPayTask quickPayTask;

    public V2ApiTask(String key, PayuConfig payuConfig) {
        this.key = key;
        this.payuConfig = payuConfig;
    }

    @Override
    public void getOffers(FetchOfferApiRequest fetchOfferApiRequest, HashGenerationListener hashGenerationListener, FetchOfferDetailsListener fetchOfferDetailsListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(fetchOfferApiRequest.getJson()));
        map.put("hashName", "get_all_offer_details");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(fetchOfferApiRequest.getJson());
            FetchOfferDetailsTask fetchOfferDetailsTask = new FetchOfferDetailsTask(fetchOfferDetailsListener);
            fetchOfferDetailsTask.execute(this.payuConfig);
        });
    }

    @Override
    public void getQuickPayOptions(QuickPayRequest quickPayRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(quickPayRequest.getJson()));
        map.put("hashName", "quickPayEvent");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(quickPayRequest.getJson());
            this.quickPayTask = new QuickPayTask(globalVaultListener);
            this.quickPayTask.execute(this.payuConfig);
        });
    }

    public void cancelQuickPayTask() {
        if (this.quickPayTask != null) {
            this.quickPayTask.cancel(true);
        }
    }

    @Override
    public void validateOffers(ValidateOfferRequest validateOfferRequest, HashGenerationListener hashGenerationListener, ValidateOfferApiListener validateOfferApiListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(validateOfferRequest.getJson()));
        map.put("hashName", "validate_offer_details");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(validateOfferRequest.getJson());
            ValidateOfferTask validateOfferTask = new ValidateOfferTask(validateOfferApiListener);
            validateOfferTask.execute(this.payuConfig);
        });
    }

    @Override
    public void getAdsDetails(AdsApiRequest adsApiRequest, FetchAdsInformationApiListener fetchAdsInformationApiListener) {
        this.payuConfig.setData(adsApiRequest.getJson());
        FetchAdsInformationTask fetchAdsInformationTask = new FetchAdsInformationTask(fetchAdsInformationApiListener);
        fetchAdsInformationTask.execute(this.payuConfig);
    }

    @Override
    public void postAdsImpressionEvent(AdsImpressionApiRequest adsImpressionApiRequest) {
        this.payuConfig.setData(adsImpressionApiRequest.getJson());
        SaveEventImpressionTask saveEventImpressionTask = new SaveEventImpressionTask();
        saveEventImpressionTask.execute(this.payuConfig);
    }

    @Override
    public void updateAdsPayUId(AdsPayUIdApiRequest adsPayUIdApiRequest) {
        this.payuConfig.setData(adsPayUIdApiRequest.getJson());
        UpdatePayUIdTask updatePayUIdTask = new UpdatePayUIdTask();
        updatePayUIdTask.execute(this.payuConfig);
    }

    @Override
    public void getEmiCalculator(CalculateEmiRequest calculateEmiRequest, HashGenerationListener hashGenerationListener, OnEmiCalculaterListener onEmiCalculaterListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(calculateEmiRequest.getJson()));
        map.put("hashName", "calculate_emi_hash");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(calculateEmiRequest.getJson());
            EmiCalculatorTask emiCalculatorTask = new EmiCalculatorTask(onEmiCalculaterListener);
            emiCalculatorTask.execute(this.payuConfig);
        });
    }

    @Override
    public void updateDeviceId(DeviceIdRequest deviceIdApiRequest, HashGenerationListener hashGenerationListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(deviceIdApiRequest.getJson()));
        map.put("hashName", "fetch_device_id");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(deviceIdApiRequest.getJson());
            UpdateDeviceIdTask updateDeviceIdTask = new UpdateDeviceIdTask();
            updateDeviceIdTask.execute(this.payuConfig);
        });
    }

    @Override
    public void globalVaultSendOTP(GlobalVaultOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put("hashName", "send_sign_in_otp");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultSendOTPTask globalVaultSendOTPTask = new GlobalVaultSendOTPTask(globalVaultListener);
            globalVaultSendOTPTask.execute(this.payuConfig);
        });
    }

    @Override
    public void globalVaultResendOTP(GlobalVaultOTPRequest globalVaultRequest, HashMap<String, String> map, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put("hashName", "resend_sign_in_otp");
        hashGenerationListener.generateSignature(hashMap, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultReSendOTPTask globalVaultReSendOTPTask = new GlobalVaultReSendOTPTask(globalVaultListener, map);
            globalVaultReSendOTPTask.execute(this.payuConfig);
        });
    }

    @Override
    public void globalVaultVerifyOTP(GlobalVaultVerifyOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put("hashName", "verify_sign_in_otp");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultVerifyOTPTask globalVaultVerifyOTPTask = new GlobalVaultVerifyOTPTask(globalVaultListener);
            globalVaultVerifyOTPTask.execute(this.payuConfig);
        });
    }

    @Override
    public void fetchIfscDetails(String ifscCode, HashGenerationListener hashGenerationListener, FetchIFSCDetailsListener fetchIFSCDetailsListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(""));
        map.put("hashName", "fetch_IFSC");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            FetchIFSCDetailsTask ifscDetailsTask = new FetchIFSCDetailsTask(fetchIFSCDetailsListener);
            ifscDetailsTask.execute(ifscCode);
        });
    }

    public void deleteSavedOptions(DeleteSavedOptionsRequest deleteSavedOptionsRequest, HashGenerationListener hashGenerationListener, DeleteSavedOptionsListener deleteSavedOptionsListener) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("signing_string", V2ApiHelper.getInstance().generateSigningString(deleteSavedOptionsRequest.getJson()));
        map.put("hashName", "deleteSavedOptions");
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, this.key);
            this.payuConfig.setData(deleteSavedOptionsRequest.getJson());
            DeleteSavedOptionsTask deleteSavedOptionsTask = new DeleteSavedOptionsTask(deleteSavedOptionsListener);
            deleteSavedOptionsTask.execute(this.payuConfig);
        });
    }
}

