/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.FetchOffer;

import android.util.Log;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchOfferApiRequest
extends V2ApiBase {
    private double amount;
    private String userToken;
    private String skuDetails;

    private FetchOfferApiRequest(Builder builder) {
        this.amount = builder.amount;
        this.userToken = builder.userToken;
        this.skuDetails = builder.skuDetails;
    }

    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (this.skuDetails != null) {
                jsonObject = this.getFetchOfferSkuJson(this.skuDetails);
            }
            jsonObject.put("amount", this.amount);
            jsonObject.put("userToken", (Object)this.userToken);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            return null;
        }
    }

    private JSONObject getFetchOfferSkuJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_id", "skuId");
        skuDetails = PayuUtils.replaceString(skuDetails, "amount_per_sku", "skuAmount");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_key", "offerKeys");
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_details", "skusDetail");
        try {
            return new JSONObject(skuDetails);
        }
        catch (JSONException jsonException) {
            return new JSONObject();
        }
    }

    public static class Builder {
        private final double amount;
        private final String userToken;
        private String skuDetails;

        public Builder(double amount, String userToken) {
            this.amount = amount;
            this.userToken = userToken;
        }

        public Builder setSkuDetails(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public FetchOfferApiRequest build() {
            return new FetchOfferApiRequest(this);
        }
    }
}

