/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class LookupRequest {
    private final String merchantAccessKey;
    private final String amount;
    private final String currency;
    private final String cardBin;
    private final String merchantOrderId;
    private final ProductType productType;
    private final String signature;

    public String getMerchantAccessKey() {
        return this.merchantAccessKey;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCardBin() {
        return this.cardBin;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public String getSignature() {
        return this.signature;
    }

    private LookupRequest(LookupApiRequestBuilder lookupApiRequestBuilder) {
        this.merchantAccessKey = lookupApiRequestBuilder.merchantAccessKey;
        this.amount = lookupApiRequestBuilder.amount;
        this.currency = lookupApiRequestBuilder.currency;
        this.cardBin = lookupApiRequestBuilder.cardBin;
        this.merchantOrderId = lookupApiRequestBuilder.merchantOrderId;
        this.productType = lookupApiRequestBuilder.productType;
        this.signature = lookupApiRequestBuilder.signature;
    }

    public String prepareJSON() {
        JSONObject jsonObject = new JSONObject();
        if (!this.isValid(this.merchantAccessKey)) {
            throw new RuntimeException("Invalid merchantAccessKey");
        }
        if (!this.isValid(this.amount)) {
            throw new RuntimeException("Invalid amount");
        }
        if (!this.isValid(this.currency)) {
            throw new RuntimeException("Invalid currency");
        }
        if (!this.isValid(this.cardBin) && this.productType != null && this.productType == ProductType.DCC) {
            throw new RuntimeException("Invalid cardBin");
        }
        if (!this.isValid(this.merchantOrderId)) {
            throw new RuntimeException("Invalid merchantOrderId");
        }
        if (this.productType == null) {
            throw new RuntimeException("Invalid productType");
        }
        if (!this.isValid(this.signature)) {
            throw new RuntimeException("Invalid signature");
        }
        try {
            jsonObject.put("merchantAccessKey", (Object)this.merchantAccessKey);
            JSONObject baseAmountObject = new JSONObject();
            baseAmountObject.put("value", (Object)this.amount);
            baseAmountObject.put("currency", (Object)this.currency);
            jsonObject.put("baseAmount", (Object)baseAmountObject);
            jsonObject.put("cardBin", (Object)this.cardBin);
            jsonObject.put("merchantOrderId", (Object)this.merchantOrderId);
            jsonObject.put("productType", (Object)this.productType.name());
            jsonObject.put("signature", (Object)this.signature);
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            throw new RuntimeException("Some error occurred");
        }
        return jsonObject.toString();
    }

    private boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }

    public static enum ProductType {
        DCC,
        MCP;

    }

    public static class LookupApiRequestBuilder {
        private String merchantAccessKey;
        private String amount;
        private String currency;
        private String cardBin;
        private String merchantOrderId;
        private ProductType productType;
        private String signature;

        public LookupApiRequestBuilder setMerchantAccessKey(String merchantAccessKey) {
            this.merchantAccessKey = merchantAccessKey;
            return this;
        }

        public LookupApiRequestBuilder setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public LookupApiRequestBuilder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public LookupApiRequestBuilder setCardBin(String cardBin) {
            this.cardBin = cardBin;
            return this;
        }

        public LookupApiRequestBuilder setMerchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public LookupApiRequestBuilder setProductType(ProductType productType) {
            this.productType = productType;
            return this;
        }

        public LookupApiRequestBuilder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public LookupRequest build() {
            return new LookupRequest(this);
        }
    }
}

