/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import com.payu.india.Model.PaymentDetailsForOffer;
import com.payu.india.Model.UserDetailsForOffer;
import com.payu.paymentparamhelper.V2ApiBase;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateOfferRequest
extends V2ApiBase {
    private String amount;
    private List<String> offerKeys;
    private PaymentDetailsForOffer paymentDetailsForOffer;
    private UserDetailsForOffer userDetailsForOffer;
    private boolean autoApply;

    private ValidateOfferRequest(Builder builder) {
        this.amount = builder.amount;
        this.offerKeys = builder.offerKeys;
        this.paymentDetailsForOffer = builder.paymentDetailsForOffer;
        this.userDetailsForOffer = builder.userDetailsForOffer;
        this.autoApply = builder.autoApply;
    }

    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("amount", (Object)this.amount);
            if (this.offerKeys != null && !this.offerKeys.isEmpty()) {
                JSONArray offerKeysArray = new JSONArray();
                for (String key : this.offerKeys) {
                    offerKeysArray.put((Object)key);
                }
                jsonObject.put("offerKeys", (Object)offerKeysArray);
            }
            jsonObject.put("paymentDetail", (Object)this.paymentDetailsForOffer.prepareJson());
            jsonObject.put("userDetail", (Object)this.userDetailsForOffer.prepareJson());
            if (this.autoApply) {
                jsonObject.put("autoApply", this.autoApply);
            }
        }
        catch (JSONException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String amount;
        private List<String> offerKeys;
        private PaymentDetailsForOffer paymentDetailsForOffer;
        private UserDetailsForOffer userDetailsForOffer;
        private boolean autoApply;

        public Builder setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public Builder setOfferKey(List<String> offerKeys) {
            this.offerKeys = offerKeys;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetailsForOffer paymentDetailsForOffer) {
            this.paymentDetailsForOffer = paymentDetailsForOffer;
            return this;
        }

        public Builder setAutoApply(boolean autoApply) {
            this.autoApply = autoApply;
            return this;
        }

        public Builder setuserDetails(UserDetailsForOffer userDetailsForOffer) {
            this.userDetailsForOffer = userDetailsForOffer;
            return this;
        }

        public ValidateOfferRequest build() {
            return new ValidateOfferRequest(this);
        }
    }
}

