/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.QuickPay;

import android.util.Log;
import com.payu.paymentparamhelper.V2ApiBase;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickPayRequest
extends V2ApiBase {
    private final double amount;
    private final String userToken;
    private final String phone;
    private final String email;
    private final String requestId;
    private final String requestType;

    private QuickPayRequest(Builder builder) {
        this.amount = builder.amount;
        this.userToken = builder.userToken;
        this.phone = builder.phone;
        this.email = builder.email;
        this.requestId = builder.requestId;
        this.requestType = builder.requestType;
    }

    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("amount", this.amount);
            jsonObject.put("userToken", (Object)this.userToken);
            jsonObject.put("phone", (Object)this.phone);
            jsonObject.put("email", (Object)this.email);
            jsonObject.put("requestId", (Object)this.requestId);
            jsonObject.put("requestType", (Object)this.requestType);
        }
        catch (JSONException e) {
            Log.d((String)"QuickPayRequest", (String)("Exception " + e.getMessage()));
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private double amount;
        private String userToken;
        private String phone;
        private String email;
        private String requestId;
        private String requestType;

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setRequestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder setPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setUserToken(String userToken) {
            this.userToken = userToken;
            return this;
        }

        public QuickPayRequest build() {
            return new QuickPayRequest(this);
        }
    }
}

