/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import android.util.Log;
import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalVaultReSendOTPTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private final GlobalVaultListener globalVaultListener;
    private final HashMap<String, String> mapHeader;

    public GlobalVaultReSendOTPTask(GlobalVaultListener listener, HashMap<String, String> map) {
        this.globalVaultListener = listener;
        this.mapHeader = map;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        Log.d((String)this.TAG, (String)"doInBackground");
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HashMap headerMap = this.getHeaderHashMap();
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "otp/resend").setPostData(payuConfig.getData()).setHeaders(headerMap).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                if (response.getInt("httpStatusCode") == 200) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    postData.setResult(response.getString("uuid"));
                } else {
                    postData.setCode(response.getInt("responseCode"));
                    postData.setStatus("ERROR");
                    postData.setResult(response.getString("responseMessage"));
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)(" ProtocolException " + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" IOException " + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException " + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private HashMap getHeaderHashMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("clientType", "simpl");
        headerMap.put("Content-Type", "application/json");
        headerMap.put("uuid", this.mapHeader.get("uuid"));
        return headerMap;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        Log.d((String)this.TAG, (String)"Result:- onPostExecute");
        this.globalVaultListener.onQuickPayResponse(payuResponse);
    }
}

