/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.PayUUserDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateOfferTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final ValidateOfferApiListener mvalidateOfferApiListener;

    public ValidateOfferTask(ValidateOfferApiListener validateOfferApiListener) {
        this.mvalidateOfferApiListener = validateOfferApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "offers/transactions/validate").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeaderWithSource("validate_offer_details")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                JSONObject result = response.optJSONObject("result");
                if (result != null) {
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    new V2ApiResponseParser().parseValidateOfferResponse(result, validateOfferDetails);
                    payuResponse.setValidateOfferDetails(validateOfferDetails);
                }
            }
        }
        catch (ProtocolException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("ProtocalException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private List<ValidateOfferInfo> prepareOfferInfoList(JSONArray offerDetailJsonArray) {
        ArrayList<ValidateOfferInfo> validateOfferInfoList = new ArrayList<ValidateOfferInfo>();
        for (int i = 0; i < offerDetailJsonArray.length(); ++i) {
            JSONObject offerDetailJson = null;
            try {
                offerDetailJson = offerDetailJsonArray.getJSONObject(i);
                validateOfferInfoList.add(this.prepareValidateOfferInfo(offerDetailJson));
                continue;
            }
            catch (JSONException e) {
                Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            }
        }
        return validateOfferInfoList;
    }

    private ValidateOfferInfo prepareValidateOfferInfo(JSONObject validateInfoJsonObject) {
        ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
        validateOfferInfo.setOfferKey(validateInfoJsonObject.optString("offerKey"));
        String offerType = validateInfoJsonObject.optString("offerType");
        validateOfferInfo.setOfferType(offerType);
        validateOfferInfo.setTitle(validateInfoJsonObject.optString("title"));
        validateOfferInfo.setDescription(validateInfoJsonObject.optString("description"));
        validateOfferInfo.setValidFrom(validateInfoJsonObject.optString("validFrom"));
        validateOfferInfo.setValidTo(validateInfoJsonObject.optString("validTo"));
        validateOfferInfo.setTnc(validateInfoJsonObject.optString("tnc"));
        validateOfferInfo.setTncLink(validateInfoJsonObject.optString("tncLink"));
        validateOfferInfo.setDiscountType(validateInfoJsonObject.optString("discountType"));
        validateOfferInfo.setOfferPercentage(validateInfoJsonObject.optString("offerPercentage"));
        validateOfferInfo.setMaxDiscountPerTxn(validateInfoJsonObject.optDouble("maxDiscountPerTxn"));
        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("maxTxnAmount")).toString()));
        validateOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("minTxnAmount")).toString()));
        validateOfferInfo.setStatus(validateInfoJsonObject.optString("status"));
        validateOfferInfo.setIsNoCostEmi(validateInfoJsonObject.optBoolean("isNce"));
        validateOfferInfo.setValid(validateInfoJsonObject.optBoolean("isValid"));
        validateOfferInfo.setOfferCategory(validateInfoJsonObject.optString("offerCategory"));
        validateOfferInfo.setSkuOffer(validateInfoJsonObject.optBoolean("isSkuOffer"));
        validateOfferInfo.setAllPaymentMethodsAvailable(validateInfoJsonObject.optBoolean("isAllPaymentMethodsAvailable"));
        validateOfferInfo.setDisallowTransactionInvalidOffer(validateInfoJsonObject.optBoolean("disallowTransactionInvalidOffer"));
        validateOfferInfo.setAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "amount"));
        validateOfferInfo.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discount"));
        validateOfferInfo.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discountedAmount"));
        validateOfferInfo.setToDisplay(validateInfoJsonObject.optBoolean("toDisplay"));
        validateOfferInfo.setUserVerificationRequired(validateInfoJsonObject.optBoolean("isUserVerificationRequired"));
        DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
        discountDetailsofOffers.setDiscount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discount"));
        discountDetailsofOffers.setDiscountType(offerType);
        discountDetailsofOffers.setDiscountedAmount(PayuUtils.getDoubleValue(validateInfoJsonObject, "discountedAmount"));
        validateOfferInfo.setDiscountDetails(discountDetailsofOffers);
        PayUUserDetails userDetails = new PayUUserDetails();
        if (validateInfoJsonObject.optJSONObject("userDetail") != null) {
            JSONObject userDetailJsonObject = validateInfoJsonObject.optJSONObject("userDetail");
            userDetails.setFirstName(userDetailJsonObject.optString("firstName"));
            userDetails.setPhoneNo(userDetailJsonObject.optString("phoneNo"));
            userDetails.setEmail(userDetailJsonObject.optString("email"));
            validateOfferInfo.setUserDetails(userDetails);
        }
        return validateOfferInfo;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mvalidateOfferApiListener.onValiDateOfferResponse(payuResponse);
    }
}

