/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.QuickPay.QuickPaySavedOption;
import com.payu.india.Model.QuickPay.RecommendedOptions;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickPayTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    private final GlobalVaultListener globalVaultListener;

    public QuickPayTask(GlobalVaultListener globalVaultListener) {
        this.globalVaultListener = globalVaultListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        Log.d((String)this.TAG, (String)"doInBackground");
        String payuResponse = "";
        PayuResponse quickPayResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "recommendation/v1/fetch").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("quickPayEvent")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                JSONObject result = jsonResponse.getJSONObject("result");
                JSONObject savedPaymentOptions = result.getJSONObject("savedPaymentOptions");
                ArrayList<QuickPaySavedOption> savedOptionArrayList = new ArrayList<QuickPaySavedOption>();
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "cc")) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("cc"), savedOptionArrayList, "cc");
                }
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "dc")) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("dc"), savedOptionArrayList, "dc");
                }
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "nb")) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("nb"), savedOptionArrayList, "nb");
                }
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "upi")) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("upi"), savedOptionArrayList, "upi");
                }
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "BNPL".toLowerCase())) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("BNPL".toLowerCase()), savedOptionArrayList, "BNPL".toLowerCase());
                }
                if (this.isJSONObjectAvailableForKey(savedPaymentOptions, "cashcard")) {
                    this.getSavedOption(savedPaymentOptions.getJSONArray("cashcard"), savedOptionArrayList, "cashcard");
                }
                quickPayResponse.setSavedOption(savedOptionArrayList);
                if (result.has("tiles")) {
                    JSONArray tiles = result.getJSONArray("tiles");
                    ArrayList<RecommendedOptions> recommendedOptions = new ArrayList<RecommendedOptions>();
                    quickPayResponse.setRecommendedOptions(this.getRecommendedOptions(tiles, recommendedOptions));
                }
                Log.d((String)this.TAG, (String)" payuResponse successfully parsed");
                if (jsonResponse.has("status") && jsonResponse.getString("status").contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                    postData.setResult(jsonResponse.getString("msg"));
                } else {
                    postData.setCode(0);
                    postData.setResult("Data fetched successfully");
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        if (this.isCancelled()) {
            return null;
        }
        quickPayResponse.setResponseStatus(postData);
        return quickPayResponse;
    }

    private void getSavedOption(JSONArray savedPaymentOptionsArray, ArrayList<QuickPaySavedOption> savedOptionArrayList, String key) {
        try {
            for (int i = 0; i < savedPaymentOptionsArray.length(); ++i) {
                QuickPaySavedOption savedOption = new QuickPaySavedOption();
                JSONObject paymentObject = savedPaymentOptionsArray.getJSONObject(i);
                int pgId = paymentObject.optInt("pgId");
                savedOption.setPgId(String.valueOf(pgId));
                savedOption.setPgTitle(paymentObject.optString("pgTitle"));
                savedOption.setPgDetails(paymentObject.optString("pgDetails"));
                savedOption.setIbiboCode(paymentObject.optString("ibiboCode"));
                savedOption.setUserCredential(paymentObject.optString("userCredentials"));
                savedOption.setPgDisplay(paymentObject.optBoolean("pgDisplay"));
                savedOption.setPgUP(paymentObject.optBoolean("pgUP"));
                savedOption.setTokenTxn(paymentObject.optBoolean("tokenTxn"));
                savedOption.setPhoneNumber(paymentObject.optString("phoneNumber"));
                savedOption.setPaymentType(key);
                savedOptionArrayList.add(savedOption);
            }
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
        }
    }

    private ArrayList<RecommendedOptions> getRecommendedOptions(JSONArray jsonArray, ArrayList<RecommendedOptions> list) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                RecommendedOptions recommendedOptions = new RecommendedOptions();
                JSONObject recommendedJsonObject = jsonArray.getJSONObject(i);
                recommendedOptions.setPaymode(PayuUtils.getPaymentTypeValue(recommendedJsonObject.optString("paymentMode").toLowerCase()));
                recommendedOptions.setIbiboCode(recommendedJsonObject.optString("ibiboCode"));
                recommendedOptions.setAction(recommendedJsonObject.optString("action"));
                recommendedOptions.setTag(recommendedJsonObject.optString("tag"));
                recommendedOptions.setUserInfo(recommendedJsonObject.optString("userInfo"));
                recommendedOptions.setPaymentInfo(recommendedJsonObject.optString("paymentInfo"));
                recommendedOptions.setEligibilityCheck(recommendedJsonObject.optBoolean("eligibilityCheck"));
                recommendedOptions.setEligibleAmount(recommendedJsonObject.optString("eligibleAmount"));
                recommendedOptions.setTitle(recommendedJsonObject.optString("title"));
                recommendedOptions.setMsg(recommendedJsonObject.optString("msg"));
                list.add(recommendedOptions);
                continue;
            }
            catch (JSONException e) {
                Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
            }
        }
        return list;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONArray(key) != null && paymentOptions.optJSONArray(key).length() != 0;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        Log.d((String)this.TAG, (String)(" onPostExecute " + payuResponse));
        if (!this.isCancelled()) {
            Log.d((String)this.TAG, (String)(" onPostExecute QuickPayTask not cancelled" + payuResponse));
            this.globalVaultListener.onQuickPayResponse(payuResponse);
        }
    }
}

