/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import com.payu.india.Interfaces.OnEmiCalculaterListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class EmiCalculatorTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private OnEmiCalculaterListener onEmiCalculaterListener;

    public EmiCalculatorTask(OnEmiCalculaterListener onEmiCalculaterListener) {
        this.onEmiCalculaterListener = onEmiCalculaterListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "sdk/calculateEmi").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("calculate_emi_hash")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response1 = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response1);
                if (response1.has("data") && response1.optJSONObject("data") != null) {
                    JSONObject validateJson;
                    JSONObject response = response1.optJSONObject("data");
                    JSONObject emiCalculatorData = response.optJSONObject("emi_sdk_data");
                    payuResponse.setRawResponse(emiCalculatorData);
                    V2ApiResponseParser v2ApiResponseParser = new V2ApiResponseParser();
                    JSONObject pricingCfJson = response.optJSONObject("pricing_cf_data");
                    if (pricingCfJson != null) {
                        JSONObject data = pricingCfJson.optJSONObject("data");
                        HashMap<String, FetchConvFeeCombinations> convFeeMap = v2ApiResponseParser.parseFetchConvFeeRespToMap(data);
                        payuResponse.setCurrentCfCharge(convFeeMap);
                    }
                    if ((validateJson = response.optJSONObject("validate_offer_data")) != null) {
                        ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                        JSONObject validateOfferJsonResult = validateJson.optJSONObject("result");
                        if (validateOfferJsonResult != null) {
                            v2ApiResponseParser.parseValidateOfferResponse(validateOfferJsonResult, validateOfferDetails);
                            payuResponse.setValidateOfferDetails(validateOfferDetails);
                        }
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.onEmiCalculaterListener.onEmiCalculatorResponse(payuResponse);
    }
}

