/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.binBaseDetails;

import android.util.Log;
import com.payu.india.Model.validateOffer.ValidateOfferRequest;
import com.payu.paymentparamhelper.V2ApiBase;
import org.json.JSONException;
import org.json.JSONObject;

public class BinBaseDetailsRequest
extends V2ApiBase {
    private final String cardNumber;
    private final String amount;
    private final String additionalCharges;
    private final String percentageAdditionalCharges;
    private final String txnId;
    private final String merchantKey;
    private final ValidateOfferRequest validateOfferRequest;
    private final boolean isPricingCFEnable;
    private final String source;
    private final boolean isSiTxn;
    private final Boolean disableConvFeeCompounding;
    private final String compoundingPercentage;

    private BinBaseDetailsRequest(Builder builder) {
        this.cardNumber = builder.cardNumber;
        this.amount = builder.amount;
        this.additionalCharges = builder.additionalCharges;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.txnId = builder.txnId;
        this.merchantKey = builder.merchantKey;
        this.validateOfferRequest = builder.validateOfferRequest;
        this.isPricingCFEnable = builder.isPricingCFEnable;
        this.source = builder.source;
        this.isSiTxn = builder.isSiTxn;
        this.disableConvFeeCompounding = builder.disableConvFeeCompounding;
        this.compoundingPercentage = builder.compoundingPercentage;
    }

    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cardNumber", (Object)this.cardNumber);
            jsonObject.put("amount", (Object)this.amount);
            jsonObject.put("additionalCharges", (Object)this.additionalCharges);
            jsonObject.put("percentageAdditionalCharges", (Object)this.percentageAdditionalCharges);
            jsonObject.put("txnId", (Object)this.txnId);
            jsonObject.put("merchantKey", (Object)this.merchantKey);
            if (this.validateOfferRequest != null) {
                jsonObject.put("validateOfferRequest", (Object)this.validateOfferRequest.getJsonValue());
            }
            jsonObject.put("isPricingCFEnable", this.isPricingCFEnable);
            jsonObject.put("source", (Object)this.source.toUpperCase());
            jsonObject.put("isSITxn", this.isSiTxn);
            jsonObject.put("disableConvFeeCompounding", (Object)this.disableConvFeeCompounding);
            if (this.compoundingPercentage != null && !this.compoundingPercentage.isEmpty()) {
                jsonObject.put("compoundingPercentage", (Object)this.compoundingPercentage);
            }
        }
        catch (JSONException e) {
            Log.d((String)"BinBaseDetailsRequest", (String)("Exception " + e.getMessage()));
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private final String cardNumber;
        private String amount;
        private String additionalCharges;
        private String percentageAdditionalCharges;
        private String txnId;
        private String merchantKey;
        private ValidateOfferRequest validateOfferRequest;
        private boolean isPricingCFEnable;
        private String source;
        private boolean isSiTxn;
        private boolean disableConvFeeCompounding;
        private String compoundingPercentage;

        public Builder(String cardNumber) {
            this.cardNumber = cardNumber;
        }

        public Builder setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAdditionalCharges(String additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges) {
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setTxnId(String txnId) {
            this.txnId = txnId;
            return this;
        }

        public Builder setMerchantKey(String merchantKey) {
            this.merchantKey = merchantKey;
            return this;
        }

        public Builder setValidateOfferRequest(ValidateOfferRequest validateOfferRequest) {
            this.validateOfferRequest = validateOfferRequest;
            return this;
        }

        public Builder setPricingCFEnable(boolean pricingCFEnable) {
            this.isPricingCFEnable = pricingCFEnable;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setIsSITxn(boolean isSiTxn) {
            this.isSiTxn = isSiTxn;
            return this;
        }

        public Builder setDisableConvFeeCompounding(Boolean disableConvFeeCompounding) {
            this.disableConvFeeCompounding = disableConvFeeCompounding;
            return this;
        }

        public Builder setCompoundingPercentage(String compoundingPercentage) {
            this.compoundingPercentage = compoundingPercentage;
            return this;
        }

        public BinBaseDetailsRequest build() {
            return new BinBaseDetailsRequest(this);
        }
    }
}

