/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class GetTransactionDetails {
    private final double amount;
    private final String additionalCharges;
    private final String percentageAdditionalCharges;
    private final boolean preAuthorize;
    private final Boolean isSiTxn;
    private final String recurringAmount;
    private final String source;
    private final String txnId;

    private GetTransactionDetails(Builder builder) {
        this.amount = builder.amount;
        this.additionalCharges = builder.additionalCharges;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.preAuthorize = builder.preAuthorize;
        this.isSiTxn = builder.isSiTxn;
        this.recurringAmount = builder.recurringAmount;
        this.source = builder.source;
        this.txnId = builder.txnId;
    }

    public JSONObject prepareTransactionDetailsJson() {
        JSONObject transactionDetailsObject = new JSONObject();
        try {
            transactionDetailsObject.put("amount", this.amount);
            if (this.txnId != null && !this.txnId.isEmpty()) {
                transactionDetailsObject.put("txnId", (Object)this.txnId);
            }
            transactionDetailsObject.put("source", (Object)this.source);
            if (this.preAuthorize) {
                transactionDetailsObject.put("pre_authorize", 1);
            }
            if (this.isSiTxn != null) {
                transactionDetailsObject.put("isSITxn", (Object)this.isSiTxn);
            }
            if (this.additionalCharges != null && !this.additionalCharges.trim().isEmpty()) {
                transactionDetailsObject.put("additional_charges", (Object)this.additionalCharges);
            }
            if (this.percentageAdditionalCharges != null && !this.percentageAdditionalCharges.trim().isEmpty()) {
                transactionDetailsObject.put("percentage_additional_charges", (Object)this.percentageAdditionalCharges);
            }
            if (this.recurringAmount != null && !this.recurringAmount.trim().isEmpty()) {
                transactionDetailsObject.put("recurringAmount", (Object)this.recurringAmount);
            }
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        return transactionDetailsObject;
    }

    public static class Builder {
        private double amount = 0.0;
        private String additionalCharges;
        private String percentageAdditionalCharges;
        private boolean preAuthorize;
        private Boolean isSiTxn;
        private String recurringAmount;
        private String source;
        private String txnId;

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAdditionalCharges(String additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges) {
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setPreAuthorize(boolean preAuthorize) {
            this.preAuthorize = preAuthorize;
            return this;
        }

        public Builder setIsSiTxn(Boolean isSiTxn) {
            this.isSiTxn = isSiTxn;
            return this;
        }

        public Builder setRecurringAmount(String recurringAmount) {
            this.recurringAmount = recurringAmount;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setTxnId(String txnId) {
            this.txnId = txnId;
            return this;
        }

        public GetTransactionDetails build() {
            return new GetTransactionDetails(this);
        }
    }
}

