/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.LookupApiListener;
import com.payu.india.Model.LookupDetails;
import com.payu.india.Model.McpConversionBean;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LookupTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    LookupApiListener mLookupApiListener;

    public LookupTask(LookupApiListener lookupApiListener) {
        this.mLookupApiListener = lookupApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://mercury.citruspay.com/multi-currency-pricing/mcp/lookup");
                    break;
                }
                case 2: {
                    url = new URL("https://sboxmercury.citruspay.com/multi-currency-pricing/mcp/lookup");
                    break;
                }
                default: {
                    url = new URL("https://mercury.citruspay.com/multi-currency-pricing/mcp/lookup");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData(), "application/json");
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (this.isJSONArrayAvailableForKey(response, "mcpConversionBeans")) {
                    JSONArray mcpArray = response.getJSONArray("mcpConversionBeans");
                    LookupDetails lookupDetails = new LookupDetails();
                    ArrayList<McpConversionBean> mcpConversionBeans = new ArrayList<McpConversionBean>();
                    for (int i = 0; i < mcpArray.length(); ++i) {
                        JSONObject mcpObject = mcpArray.optJSONObject(i);
                        if (mcpObject == null) continue;
                        McpConversionBean mcpConversionBean = new McpConversionBean();
                        mcpConversionBean.setOfferAmount(mcpObject.optString("offerAmount"));
                        mcpConversionBean.setOfferCurrency(mcpObject.optString("offerCurrency"));
                        mcpConversionBean.setOfferExchangeRate(mcpObject.optString("offerExchangeRate"));
                        mcpConversionBean.setMerchantOrderId(mcpObject.optString("merchantOrderId"));
                        mcpConversionBean.setLookupId(mcpObject.optString("lookupId"));
                        mcpConversionBeans.add(mcpConversionBean);
                    }
                    lookupDetails.setMcpConversionBeans(mcpConversionBeans);
                    if (this.isJSONArrayAvailableForKey(response, "supportedCardSchemes")) {
                        JSONArray cardSchemesArray = response.getJSONArray("supportedCardSchemes");
                        ArrayList<String> supportedCardSchemes = new ArrayList<String>();
                        for (int i = 0; i < cardSchemesArray.length(); ++i) {
                            String cardScheme = cardSchemesArray.optString(i);
                            if (cardScheme == null || cardScheme.isEmpty()) continue;
                            supportedCardSchemes.add(cardScheme);
                        }
                        lookupDetails.setSupportedCardSchemes(supportedCardSchemes);
                    }
                    payuResponse.setLookupDetails(lookupDetails);
                }
                if (response.has("resultCode") && response.getInt("resultCode") != 0) {
                    postData.setCode(response.getInt("resultCode"));
                    postData.setResult(response.getString("resultMessage"));
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                payuResponse.setResponseStatus(postData);
            }
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)("JSONException " + e.getMessage()));
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mLookupApiListener.onLookupApiResponse(payuResponse);
    }

    private boolean isJSONArrayAvailableForKey(JSONObject response, String key) throws JSONException {
        if (response == null || key == null || key.isEmpty()) {
            return false;
        }
        return response.has(key) && response.optJSONArray(key) != null && response.getJSONArray(key).length() > 0;
    }
}

