/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.GetOfferStatusApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetOfferStatusTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    GetOfferStatusApiListener mGetOfferStatusApiListener;

    public GetOfferStatusTask(GetOfferStatusApiListener getOfferStatusApiListener) {
        this.mGetOfferStatusApiListener = getOfferStatusApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("status") && response.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                PayuOffer payuOffer = new PayuOffer();
                Iterator keys = response.keys();
                while (keys.hasNext()) {
                    switch ((String)keys.next()) {
                        case "status": {
                            payuOffer.setStatus(response.getString("status"));
                            break;
                        }
                        case "msg": {
                            payuOffer.setMsg(response.getString("msg"));
                            break;
                        }
                        case "error_code": {
                            payuOffer.setErrorCode(response.getString("error_code"));
                            break;
                        }
                        case "offer_key": {
                            payuOffer.setOfferKey(response.getString("offer_key"));
                            break;
                        }
                        case "offer_type": {
                            payuOffer.setOfferType(response.getString("offer_type"));
                            break;
                        }
                        case "offer_availed_count": {
                            payuOffer.setOfferAvailedCount(response.getString("offer_availed_count"));
                            break;
                        }
                        case "offer_remaining_count": {
                            payuOffer.setOfferRemainingCount(response.getString("offer_remaining_count"));
                            break;
                        }
                        case "discount": {
                            payuOffer.setDiscount(response.getString("discount"));
                            break;
                        }
                        case "category": {
                            payuOffer.setCategory(response.getString("category"));
                        }
                    }
                }
                payuResponse.setPayuOffer(payuOffer);
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)("MalformedURLException " + e.getMessage()));
        }
        catch (ProtocolException e) {
            Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)("JSONException " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mGetOfferStatusApiListener.onGetOfferStatusApiResponse(payuResponse);
    }
}

