/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.GetCardInformationApiListener;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetCardInformationTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    GetCardInformationApiListener mGetCardInformationApiListener;

    public GetCardInformationTask(GetCardInformationApiListener getCardInformationApiListener) {
        this.mGetCardInformationApiListener = getCardInformationApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("status") && response.getInt("status") == 0) {
                    postData.setCode(5017);
                    postData.setStatus("ERROR");
                } else {
                    CardInformation cardInformation = new CardInformation();
                    cardInformation.setIsDomestic(response.getString("isDomestic").contentEquals("Y"));
                    cardInformation.setIssuingBank(response.getString("issuingBank"));
                    cardInformation.setCardType(response.getString("cardType"));
                    cardInformation.setCardCategory(response.getString("cardCategory"));
                    payuResponse.setCardInformation(cardInformation);
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        catch (IOException | JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mGetCardInformationApiListener.onGetCardInformationResponse(payuResponse);
    }
}

