/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchConvFeeTask
extends PayUAsyncTask<PayuConfig, String, ApiResponse<FetchConvFeeResponse>> {
    private final String TAG = this.getClass().getSimpleName();
    private final V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener;

    public FetchConvFeeTask(V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener) {
        this.v2ApiResponseListener = v2ApiResponseListener;
    }

    protected ApiResponse<FetchConvFeeResponse> doInBackground(PayuConfig ... params) {
        Log.d((String)this.TAG, (String)"doInBackground");
        ApiResponse<FetchConvFeeResponse> apiResponse = new ApiResponse<FetchConvFeeResponse>();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "sdk/checkoutx/fetchConvenienceFee").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("fetchConvFee")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                new V2ApiResponseParser().parseFetchConvFeeResponse(jsonResponse, apiResponse);
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }

    @Override
    protected void onPostExecute(ApiResponse<FetchConvFeeResponse> apiResponse) {
        super.onPostExecute(apiResponse);
        this.v2ApiResponseListener.onApiResponse(apiResponse);
    }
}

