/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import com.payu.india.Interfaces.DeleteTokenisedCardApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteTokenisedCardTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private DeleteTokenisedCardApiListener mDeleteTokenisedCardApiListener;

    public DeleteTokenisedCardTask(DeleteTokenisedCardApiListener deleteTokenisedCardApiListener) {
        this.mDeleteTokenisedCardApiListener = deleteTokenisedCardApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        StoredCard storedCard = new StoredCard();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("status") && response.getString("status").contentEquals("0")) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                }
                if (response.has("status") && response.getString("status").contentEquals("1")) {
                    postData.setStatus("SUCCESS");
                    postData.setCode(0);
                }
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
            }
        }
        catch (MalformedURLException e) {
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (ProtocolException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mDeleteTokenisedCardApiListener.onDeleteTokenisedCardResponse(payuResponse);
    }
}

