/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.CheckBalanceListener;
import com.payu.india.Model.Olw.OlwSDKInfo;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.SodexoCardInfo;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckBalanceTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final String TAG = this.getClass().getSimpleName();
    CheckBalanceListener checkBalanceListener;

    public CheckBalanceTask(CheckBalanceListener checkBalanceListener) {
        this.checkBalanceListener = checkBalanceListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse;
        block17: {
            payuResponse = new PayuResponse();
            PostData postData = new PostData();
            try {
                URL url = null;
                PayuConfig payuConfig = params[0];
                switch (payuConfig.getEnvironment()) {
                    case 0: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                        break;
                    }
                    case 1: {
                        url = new URL("https://test.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 2: {
                        url = new URL("https://test.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 3: {
                        url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    default: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    }
                }
                HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData(), payuConfig.getFetchSodexoBalanceTimeout());
                if (null == conn) break block17;
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                SodexoCardInfo sodexoCardInfo = new SodexoCardInfo();
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    sodexoCardInfo.setCardNo(jsonResponse.optString("cardNo"));
                    sodexoCardInfo.setCardBalance(jsonResponse.optString("cardBalance"));
                    sodexoCardInfo.setCardName(jsonResponse.optString("cardName"));
                    sodexoCardInfo.setMsg(jsonResponse.optString("msg"));
                    JSONObject olwJson = jsonResponse.optJSONObject("olw");
                    if (olwJson != null) {
                        Iterator olwKeys = olwJson.keys();
                        while (olwKeys.hasNext()) {
                            JSONObject bankCodeJson = olwJson.optJSONObject((String)olwKeys.next());
                            if (bankCodeJson == null) continue;
                            boolean isMPinSet = bankCodeJson.optBoolean("mpinSet");
                            boolean customerRegistered = bankCodeJson.optBoolean("customerRegistered");
                            OlwSDKInfo olwSDKInfo = new OlwSDKInfo();
                            olwSDKInfo.setMPinSet(isMPinSet);
                            olwSDKInfo.setCustomerRegistered(customerRegistered);
                            sodexoCardInfo.setCardBalance(bankCodeJson.optString("balance"));
                            sodexoCardInfo.setOlwSDKInfo(olwSDKInfo);
                        }
                    }
                } else {
                    sodexoCardInfo.setCardNo(jsonResponse.optString("cardNo"));
                    sodexoCardInfo.setCardBalance(jsonResponse.optString("cardBalance"));
                    sodexoCardInfo.setCardName(jsonResponse.optString("cardName"));
                    sodexoCardInfo.setMsg(jsonResponse.optString("msg"));
                    JSONObject olwJson = jsonResponse.optJSONObject("olw");
                    if (olwJson != null) {
                        Iterator olwKeys = olwJson.keys();
                        while (olwKeys.hasNext()) {
                            JSONObject bankCodeJson = olwJson.optJSONObject((String)olwKeys.next());
                            if (bankCodeJson == null) continue;
                            boolean isMPinSet = bankCodeJson.optBoolean("mpinSet");
                            boolean customerRegistered = bankCodeJson.optBoolean("customerRegistered");
                            OlwSDKInfo olwSDKInfo = new OlwSDKInfo();
                            olwSDKInfo.setMPinSet(isMPinSet);
                            olwSDKInfo.setCustomerRegistered(customerRegistered);
                            sodexoCardInfo.setCardBalance(bankCodeJson.optString("balance"));
                            sodexoCardInfo.setOlwSDKInfo(olwSDKInfo);
                        }
                    }
                }
                payuResponse.setSodexoCardInfo(sodexoCardInfo);
            }
            catch (MalformedURLException e) {
                Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
            }
            catch (ProtocolException e) {
                Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
            }
            catch (IOException e) {
                Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
            }
            catch (JSONException e) {
                Log.d((String)this.TAG, (String)("ProtocolException " + e.getMessage()));
            }
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.checkBalanceListener.onCheckBalanceResponse(payuResponse);
    }
}

