/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PostData;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeCombinations;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Payu.v2ApiResponseParser.V2ApiResponseParser;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class BinBaseDetailsTask
extends PayUAsyncTask<PayuConfig, String, ApiResponse<BinBaseDetailsResponse>> {
    private final String TAG = this.getClass().getSimpleName();
    private final V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener;

    public BinBaseDetailsTask(V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener) {
        this.v2ApiResponseListener = v2ApiResponseListener;
    }

    protected ApiResponse<BinBaseDetailsResponse> doInBackground(PayuConfig ... params) {
        Log.d((String)this.TAG, (String)"doInBackground");
        String payuResponse = "";
        ApiResponse<BinBaseDetailsResponse> apiResponse = new ApiResponse<BinBaseDetailsResponse>();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "sdk/card/binDetails").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("binBaseDetails")).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                apiResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 0) {
                    postData.setCode(5050);
                    postData.setStatus("ERROR");
                    postData.setResult(jsonResponse.optString("data") != null ? jsonResponse.optString("data") : "Something went wong.");
                } else if (jsonResponse.optInt("status") == 1) {
                    JSONObject pricingCfJson;
                    JSONObject validateOfferJsonResult;
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    BinBaseDetailsResponse binBaseDetailsResponse = new BinBaseDetailsResponse();
                    CardInformation cardInformation = new CardInformation();
                    V2ApiResponseParser v2ApiResponseParser = new V2ApiResponseParser();
                    v2ApiResponseParser.parseBinInfoResponse(jsonResponse, cardInformation);
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    JSONObject validateJson = jsonResponse.optJSONObject("validate_offer_data");
                    binBaseDetailsResponse.setCardInformation(cardInformation);
                    if (validateJson != null && (validateOfferJsonResult = validateJson.optJSONObject("result")) != null) {
                        v2ApiResponseParser.parseValidateOfferResponse(validateOfferJsonResult, validateOfferDetails);
                        binBaseDetailsResponse.setValidateOfferDetails(validateOfferDetails);
                    }
                    if ((pricingCfJson = jsonResponse.optJSONObject("pricing_cf_data")) != null) {
                        JSONObject data = pricingCfJson.optJSONObject("data");
                        HashMap<String, FetchConvFeeCombinations> convFeeMap = v2ApiResponseParser.parseFetchConvFeeRespToMap(data);
                        binBaseDetailsResponse.setConvFeeChargesMap(convFeeMap);
                    }
                    apiResponse.setPayuResponse(binBaseDetailsResponse);
                }
            }
        }
        catch (MalformedURLException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5022);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)(" MalformedURLException" + e.getMessage()));
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            Log.d((String)this.TAG, (String)(" JSONException" + e.getMessage()));
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        apiResponse.setPostData(postData);
        return apiResponse;
    }

    @Override
    protected void onPostExecute(ApiResponse<BinBaseDetailsResponse> apiResponse) {
        super.onPostExecute(apiResponse);
        this.v2ApiResponseListener.onApiResponse(apiResponse);
    }
}

