/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import com.payu.india.Model.Authorization;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class V2ApiHelper {
    private String date;
    private String authHeder;
    private Authorization authorization = new Authorization();
    private static V2ApiHelper instance = null;

    private V2ApiHelper() {
    }

    public static V2ApiHelper getInstance() {
        if (instance == null) {
            instance = new V2ApiHelper();
        }
        return instance;
    }

    public String generateSigningString(String jsonString) {
        Date myDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(myDate);
        calendar.add(12, -330);
        Date time = calendar.getTime();
        SimpleDateFormat outputFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        this.date = outputFmt.format(time);
        this.authorization.setDate(this.date);
        String signingString = jsonString + "|" + this.date + "|";
        return signingString;
    }

    public HashMap<String, String> getAuthHeader(String key) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("date", this.authorization.getDate());
        headerMap.put("Content-Type", "application/json");
        this.authHeder = "hmac username=\"" + this.authorization.getMerchantkey() + "\", algorithm=\"sha512\", headers=\"date\", signature=\"" + this.authorization.getSignature(key) + "\"";
        headerMap.put("authorization", this.authHeder);
        return headerMap;
    }

    public HashMap<String, String> getOlwAuthHeader(String key, HashMap<String, String> headerMapExtra) {
        HashMap<String, String> headerMap = this.getAuthHeader(key);
        if (!headerMapExtra.isEmpty()) {
            headerMap.putAll(headerMapExtra);
        }
        return headerMap;
    }

    public HashMap<String, String> getAuthHeaderWithSource(String key) {
        HashMap<String, String> headerMap = this.getAuthHeader(key);
        headerMap.put("source", "Android_SDK");
        return headerMap;
    }

    public void setAuthHeader(HashMap<String, String> signature, String key) {
        this.authorization.setMerchantkey(key);
        this.authorization.setDate(this.date);
        this.authorization.setSignature(signature);
    }

    public String getApiEndPoint(String commandName) {
        switch (commandName) {
            case "sendOtp": {
                return "loyalty-points/ppi/v1/otp/send";
            }
            case "setMPin": 
            case "forgetMPin": {
                return "loyalty-points/ppi/v1/set-reset/mpin";
            }
            case "verifyMapin": {
                return "loyalty-points/ppi/v1/verifyMpinDeviceIdToken";
            }
        }
        throw new IllegalArgumentException("Unknown command name: " + commandName);
    }
}

