/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.fetchConvenienceFee;

import android.util.Log;
import com.payu.india.Model.fetchConvenienceFee.CommonDynamicAttributes;
import com.payu.india.Model.fetchConvenienceFee.VariableDynamicAttributes;
import com.payu.paymentparamhelper.V2ApiBase;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchConvFeeRequest
extends V2ApiBase {
    private final String payuId;
    private final String merchantKey;
    private final double amount;
    private final String source;
    private final String timeStamp;
    private final String requestId;
    private final CommonDynamicAttributes commonDynamicAttributes;
    private final List<VariableDynamicAttributes> variableDynamicAttributesList;

    public FetchConvFeeRequest(Builder builder) {
        this.payuId = builder.payuId;
        this.merchantKey = builder.merchantKey;
        this.amount = builder.amount;
        this.source = builder.source;
        this.timeStamp = builder.timeStamp;
        this.requestId = builder.requestId;
        this.commonDynamicAttributes = builder.commonDynamicAttributes;
        this.variableDynamicAttributesList = builder.variableDynamicAttributesList;
    }

    public String getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONArray jsonArray;
            jsonObject.put("payuId", (Object)this.payuId);
            jsonObject.put("merchantKey", (Object)this.merchantKey);
            jsonObject.put("amount", this.amount);
            jsonObject.put("source", (Object)this.source);
            jsonObject.put("timeStamp", (Object)this.timeStamp);
            jsonObject.put("requestId", (Object)this.requestId);
            JSONObject commonAttributes = this.getCommonDynamicAttributes(this.commonDynamicAttributes);
            if (commonAttributes != null) {
                jsonObject.put("commonDynamicAttributes", (Object)commonAttributes);
            }
            if ((jsonArray = this.getVariableDynamicAttributesJsonarray(this.variableDynamicAttributesList)) != null) {
                jsonObject.put("variableDynamicAttributes", (Object)jsonArray);
            }
        }
        catch (JSONException e) {
            Log.d((String)"BinBaseDetailsRequest", (String)("Exception " + e.getMessage()));
        }
        return jsonObject.toString();
    }

    private JSONArray getVariableDynamicAttributesJsonarray(List<VariableDynamicAttributes> variableDynamicAttributesList) {
        JSONArray jsonArray = new JSONArray();
        for (VariableDynamicAttributes variableDynamicAttribute : variableDynamicAttributesList) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("combinationKey", (Object)variableDynamicAttribute.getCombinationKey());
                jsonObject.put("ibiboCode", (Object)variableDynamicAttribute.getIbiboCode());
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return jsonArray;
    }

    private JSONObject getCommonDynamicAttributes(CommonDynamicAttributes commonDynamicAttributes) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mode", (Object)commonDynamicAttributes.getMode());
            jsonObject.put("action", (Object)"capture");
        }
        catch (JSONException e) {
            return null;
        }
        return jsonObject;
    }

    public static class Builder {
        private String payuId;
        private String merchantKey;
        private double amount;
        private String source;
        private String timeStamp;
        private String requestId;
        private CommonDynamicAttributes commonDynamicAttributes;
        private List<VariableDynamicAttributes> variableDynamicAttributesList;

        public Builder setPayuId(String payuId) {
            this.payuId = payuId;
            return this;
        }

        public Builder setMerchantKey(String merchantKey) {
            this.merchantKey = merchantKey;
            return this;
        }

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Builder setCommonDynamicAttributes(CommonDynamicAttributes commonDynamicAttributes) {
            this.commonDynamicAttributes = commonDynamicAttributes;
            return this;
        }

        public Builder setVariableDynamicAttributesList(List<VariableDynamicAttributes> variableDynamicAttributesList) {
            this.variableDynamicAttributesList = variableDynamicAttributesList;
            return this;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public FetchConvFeeRequest build() {
            return new FetchConvFeeRequest(this);
        }
    }
}

