/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckoutDetailsListener;
import com.payu.india.Model.Bnpl;
import com.payu.india.Model.Emi;
import com.payu.india.Model.MerchantInfo;
import com.payu.india.Model.MerchantParamInfo;
import com.payu.india.Model.PayUEmiTenures;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.TaxSpecification;
import com.payu.india.Model.Upi;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetCheckoutDetailsTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private CheckoutDetailsListener mCheckoutDetailsListener;

    public GetCheckoutDetailsTask(CheckoutDetailsListener checkoutDetailsListener) {
        this.mCheckoutDetailsListener = checkoutDetailsListener;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 4: {
                    url = new URL("https://bizcheckouttest.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("details") && response.optJSONObject("details") != null) {
                    JSONObject paymentOptions;
                    JSONObject configObject;
                    JSONArray issuingBanks;
                    JSONObject downInfoObject;
                    JSONObject details = response.getJSONObject("details");
                    JSONArray offersArray = details.optJSONArray("offers");
                    if (offersArray != null && offersArray.length() != 0) {
                        ArrayList<PayuOffer> offersList = new ArrayList<PayuOffer>();
                        for (int i2 = 0; i2 < offersArray.length(); ++i2) {
                            JSONObject offerObject = offersArray.getJSONObject(i2);
                            PayuOffer payuOffer = new PayuOffer();
                            payuOffer.setId(offerObject.optString("id"));
                            payuOffer.setTitle(offerObject.optString("title"));
                            payuOffer.setDescription(offerObject.optString("description"));
                            payuOffer.setMinAmount(offerObject.optString("min_amount"));
                            payuOffer.setDiscount(offerObject.optString("discount"));
                            payuOffer.setDiscountUnit(offerObject.optString("discount_unit"));
                            payuOffer.setOfferType(offerObject.optString("offer_type"));
                            payuOffer.setValidOnDays(offerObject.optString("valid_on_days"));
                            payuOffer.setOfferKey("@" + offerObject.optString("id"));
                            offersList.add(payuOffer);
                        }
                        payuResponse.setOfferDetailsList(offersList);
                    }
                    if ((downInfoObject = details.optJSONObject("downInfo")) != null && downInfoObject.length() != 0 && (issuingBanks = downInfoObject.optJSONArray("issuingBanks")) != null && issuingBanks.length() != 0) {
                        ArrayList<String> issuingBanksList = new ArrayList<String>();
                        for (int i3 = 0; i3 < issuingBanks.length(); ++i3) {
                            if (issuingBanks.optString(i3) == null || issuingBanks.getString(i3).isEmpty()) continue;
                            issuingBanksList.add(issuingBanks.getString(i3));
                        }
                        payuResponse.setDownIssuingBanks(issuingBanksList);
                    }
                    MerchantInfo merchantInfo = new MerchantInfo();
                    JSONObject merchant = details.optJSONObject("merchant");
                    if (merchant != null && merchant.length() != 0) {
                        JSONObject merchantParamObj;
                        if (merchant.optString("logo") != null) {
                            merchantInfo.setLogo(merchant.optString("logo"));
                        }
                        merchantInfo.setDisplayName(merchant.optString("displayName"));
                        String retryCount = merchant.optString("retryAllowed");
                        if (retryCount != null && !retryCount.isEmpty()) {
                            merchantInfo.setRetryCount(Integer.parseInt(retryCount));
                        }
                        if ((merchantParamObj = merchant.optJSONObject("merchant_param")) != null && merchantParamObj.has("isAdsEnabled")) {
                            MerchantParamInfo paramInfo = new MerchantParamInfo();
                            paramInfo.setAdsEnabled(merchantParamObj.optInt("isAdsEnabled") == 1);
                            merchantInfo.setMerchantParamInfo(paramInfo);
                        }
                        if (merchant.optJSONArray("minkasuIbiboCodes") != null) {
                            merchantInfo.setOneClickPayBankCodes(this.getArrayListFromJsonArray(merchant.getJSONArray("minkasuIbiboCodes")));
                        }
                        payuResponse.setMerchantInfo(merchantInfo);
                    }
                    if ((configObject = details.optJSONObject("config")) != null) {
                        TaxSpecification taxSpecification = new TaxSpecification();
                        taxSpecification.setCcTaxValue(this.getTaxFromConfigObject(configObject, "cc"));
                        taxSpecification.setDcTaxValue(this.getTaxFromConfigObject(configObject, "dc"));
                        taxSpecification.setNbTaxValue(this.getTaxFromConfigObject(configObject, "nb"));
                        taxSpecification.setUpiTaxValue(this.getTaxFromConfigObject(configObject, "upi"));
                        taxSpecification.setEmiTaxValue(this.getTaxFromConfigObject(configObject, "emi"));
                        taxSpecification.setCashTaxValue(this.getTaxFromConfigObject(configObject, "cash"));
                        taxSpecification.setEnachTaxValue(this.getTaxFromConfigObject(configObject, "enach"));
                        taxSpecification.setLazypayTaxValue(this.getTaxFromConfigObject(configObject, "lazypay"));
                        taxSpecification.setSiTaxValue(this.getTaxFromConfigObject(configObject, "si"));
                        taxSpecification.setNeftRtgsTaxValue(this.getTaxFromConfigObject(configObject, "neftrtgs"));
                        taxSpecification.setMealCardTaxValue(this.getTaxFromConfigObject(configObject, "mc"));
                        taxSpecification.setBnplTaxValue(this.getTaxFromConfigObject(configObject, "bnpl"));
                        payuResponse.setTaxSpecification(taxSpecification);
                    }
                    if ((paymentOptions = details.optJSONObject("paymentOptions")) != null && paymentOptions.length() > 0) {
                        ArrayList<Bnpl> bnplList;
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "cc")) {
                            payuResponse.setCreditCard(this.prepareListWithKeyData(details, "cc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "dc")) {
                            payuResponse.setDebitCard(this.prepareListWithKeyData(details, "dc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "nb")) {
                            ArrayList<PaymentDetails> nbList = this.prepareListWithKeyData(details, "nb");
                            Collections.sort(nbList, new PaymentDetailsComparator());
                            payuResponse.setNetBanks(nbList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "enach")) {
                            ArrayList<PaymentDetails> nbSiList = this.prepareListWithKeyData(details, "enach");
                            payuResponse.setSiBankList(nbSiList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "si")) {
                            ArrayList<PaymentDetails> siList = this.prepareListWithKeyData(details, "si");
                            payuResponse.setStandingInstructions(siList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "neftrtgs")) {
                            ArrayList<PaymentDetails> nfetrtgsList = this.prepareListWithKeyData(details, "neftrtgs");
                            payuResponse.setNeftRtgs(nfetrtgsList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "cash")) {
                            ArrayList<PaymentDetails> walletList = this.prepareListWithKeyData(details, "cash");
                            PaymentDetails paymentDetails = this.getPhonePeIntentFromList(walletList);
                            if (paymentDetails != null) {
                                payuResponse.setPhonePe(paymentDetails);
                            }
                            Collections.sort(walletList, new PaymentDetailsComparator());
                            payuResponse.setCashCard(walletList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "ivr")) {
                            payuResponse.setIvr(this.prepareListWithKeyData(details, "ivr"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "ivrdc")) {
                            payuResponse.setIvrdc(this.prepareListWithKeyData(details, "ivrdc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "upi")) {
                            Upi upi;
                            JSONObject upiCollections;
                            JSONObject upiObject = paymentOptions.getJSONObject("upi").getJSONObject("all");
                            if (upiObject.has("upi".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("upi".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.optString("title"));
                                upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                                upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "upi"));
                                upi.setOfferDetailsList(this.getOffersList(offersArray, upiCollections.optJSONArray("offers")));
                                payuResponse.setUpi(upi);
                            }
                            if (upiObject.has("TEZ".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("TEZ".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.optString("title"));
                                upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                                upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "TEZ"));
                                upi.setOfferDetailsList(this.getOffersList(offersArray, upiCollections.optJSONArray("offers")));
                                payuResponse.setGoogleTez(upi);
                            }
                            if (upiObject.has("TEZOMNI".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("TEZOMNI".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.optString("title"));
                                upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                                upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "TEZ"));
                                upi.setOfferDetailsList(this.getOffersList(offersArray, upiCollections.optJSONArray("offers")));
                                payuResponse.setGoogleTezOmni(upi);
                            }
                            if (upiObject.has("INTENT".toUpperCase())) {
                                upiCollections = upiObject.getJSONObject("INTENT".toUpperCase());
                                upi = new Upi();
                                upi.setTitle(upiCollections.optString("title"));
                                upi.setAdditionalCharge(upiCollections.optString("additionalCharge"));
                                upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "INTENT"));
                                upi.setOfferDetailsList(this.getOffersList(offersArray, upiCollections.optJSONArray("offers")));
                                payuResponse.setGenericIntent(upi);
                            }
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "emi")) {
                            ArrayList<Emi> cardlessList;
                            ArrayList<Emi> dcemiList;
                            ArrayList<Emi> ccemiList = this.getEmiList(details, "cc");
                            if (ccemiList != null && !ccemiList.isEmpty()) {
                                payuResponse.setCcemi(ccemiList);
                            }
                            if ((dcemiList = this.getEmiList(details, "dc")) != null && !dcemiList.isEmpty()) {
                                payuResponse.setDcemi(dcemiList);
                            }
                            ArrayList<Emi> cardlessemiList = new ArrayList<Emi>();
                            ArrayList<Emi> otheremiList = this.getEmiList(details, "other");
                            if (otheremiList != null && !otheremiList.isEmpty()) {
                                cardlessemiList.addAll(otheremiList);
                            }
                            if ((cardlessList = this.getEmiList(details, "cardless")) != null && !cardlessList.isEmpty()) {
                                cardlessemiList.addAll(cardlessList);
                            }
                            if (!cardlessemiList.isEmpty()) {
                                payuResponse.setCardlessemi(cardlessemiList);
                            }
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "lazypay")) {
                            payuResponse.setLazyPay(this.prepareListWithKeyData(details, "lazypay"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "bnpl") && (bnplList = this.prepareBnplListWithKeyData(details, "bnpl")) != null && !bnplList.isEmpty()) {
                            payuResponse.setBnpl(bnplList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "mc")) {
                            payuResponse.setMealCard(this.prepareListWithKeyData(details, "mc"));
                        }
                    }
                }
                if (response.has("status") && response.getString("status").contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                    postData.setResult(response.getString("msg"));
                } else {
                    postData.setCode(0);
                    postData.setResult("Data fetched successfully");
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (ProtocolException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            postData.setCode(5004);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private ArrayList<Emi> getEmiList(JSONObject details, String emiType) throws JSONException {
        JSONObject ccObject = details.getJSONObject("paymentOptions").getJSONObject("emi").getJSONObject("all").optJSONObject(emiType);
        if (ccObject != null && ccObject.optJSONObject("all") != null) {
            JSONObject allObject = ccObject.getJSONObject("all");
            Iterator keysIterator = allObject.keys();
            ArrayList<Emi> emiList = new ArrayList<Emi>();
            while (keysIterator.hasNext()) {
                String code = (String)keysIterator.next();
                JSONObject emiObject = allObject.getJSONObject(code);
                Emi emi = new Emi();
                emi.setBankName(code);
                emi.setBankTitle(emiObject.optString("title"));
                emi.setShortTitle(emiObject.optString("shortTitle"));
                emi.setMinAmount(emiObject.optString("minimumAmount"));
                emi.setMaxAmount(emiObject.optString("maximumAmount"));
                JSONObject tenureOptions = emiObject.getJSONObject("tenureOptions");
                JSONObject bankEligibility = emiObject.optJSONObject("eligibility");
                if (bankEligibility != null) {
                    emi.setStatus(bankEligibility.optBoolean("status"));
                    emi.setReason(bankEligibility.optString("reason"));
                }
                ArrayList<PayUEmiTenures> payUEmiTenuresList = new ArrayList<PayUEmiTenures>();
                Iterator tenureKeysIterator = tenureOptions.keys();
                while (tenureKeysIterator.hasNext()) {
                    String bankCode = (String)tenureKeysIterator.next();
                    JSONObject tenureObject = tenureOptions.getJSONObject(bankCode);
                    JSONObject eligibility = tenureObject.optJSONObject("eligibility");
                    PayUEmiTenures payUEmiTenures = new PayUEmiTenures();
                    payUEmiTenures.setBankCode(bankCode);
                    payUEmiTenures.setAdditionalCharge(tenureObject.optString("additionalCharge"));
                    payUEmiTenures.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), "emi", bankCode));
                    payUEmiTenures.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), tenureObject.optJSONArray("offers")));
                    payUEmiTenures.setMinAmount(tenureObject.optString("minimumAmount"));
                    payUEmiTenures.setMaxAmount(tenureObject.optString("maximumAmount"));
                    payUEmiTenures.setTenure(tenureObject.optString("tenure"));
                    payUEmiTenures.setInterestRate(tenureObject.optString("interestRate"));
                    payUEmiTenures.setMonthlyEmi(tenureObject.optString("monthlyEmi"));
                    payUEmiTenures.setInterestCharged(tenureObject.optString("interestCharged"));
                    payUEmiTenures.setPaybackAmount(tenureObject.optString("paybackAmount"));
                    payUEmiTenures.setBankCharge(tenureObject.optString("bankCharge"));
                    if (eligibility != null) {
                        payUEmiTenures.setStatus(eligibility.optBoolean("status"));
                        payUEmiTenures.setReason(eligibility.optString("reason"));
                    }
                    payUEmiTenuresList.add(payUEmiTenures);
                }
                emi.setPayUEmiTenuresList(payUEmiTenuresList);
                emiList.add(emi);
            }
            return emiList;
        }
        return null;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mCheckoutDetailsListener.onCheckoutDetailsResponse(payuResponse);
    }

    private PaymentDetails getPhonePeIntentFromList(ArrayList<PaymentDetails> paymentDetailsList) {
        if (paymentDetailsList == null || paymentDetailsList.size() == 0 || "PPINTENT" == null || "PPINTENT".isEmpty()) {
            return null;
        }
        for (PaymentDetails paymentDetails : paymentDetailsList) {
            if (!paymentDetails.getBankCode().equalsIgnoreCase("PPINTENT")) continue;
            return paymentDetails;
        }
        return null;
    }

    private ArrayList<PaymentDetails> prepareListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONObject allObject = details.getJSONObject("paymentOptions").getJSONObject(key).getJSONObject("all");
        ArrayList<PaymentDetails> paymentDetailsList = new ArrayList<PaymentDetails>();
        Iterator keysIterator = allObject.keys();
        while (keysIterator.hasNext()) {
            String bankCode = (String)keysIterator.next();
            JSONObject ccObject = allObject.getJSONObject(bankCode);
            PaymentDetails paymentDetails = new PaymentDetails();
            paymentDetails.setBankCode(bankCode);
            paymentDetails.setBankName(ccObject.optString("title"));
            paymentDetails.setAdditionalCharge(ccObject.optString("additionalCharge"));
            paymentDetails.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), key, bankCode));
            paymentDetails.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), ccObject.optJSONArray("offers")));
            JSONArray verificationModeJsonArray = ccObject.optJSONArray("verificationMode");
            if (null != verificationModeJsonArray && verificationModeJsonArray.length() > 0) {
                paymentDetails.setVerificationModeList(this.getArrayListFromJsonArray(verificationModeJsonArray));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<Bnpl> prepareBnplListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONObject allObject = details.getJSONObject("paymentOptions").getJSONObject(key).getJSONObject("all");
        ArrayList<Bnpl> paymentDetailsList = new ArrayList<Bnpl>();
        Iterator keysIterator = allObject.keys();
        while (keysIterator.hasNext()) {
            String bankCode = (String)keysIterator.next();
            JSONObject ccObject = allObject.getJSONObject(bankCode);
            Bnpl paymentDetails = new Bnpl();
            paymentDetails.setBankCode(bankCode);
            paymentDetails.setBankName(ccObject.optString("title"));
            paymentDetails.setAdditionalCharge(ccObject.optString("additionalCharge"));
            paymentDetails.setMinAmount(ccObject.optString("minimumAmount"));
            paymentDetails.setMaxAmount(ccObject.optString("minimumAmount"));
            JSONObject eligibility = ccObject.optJSONObject("eligibility");
            if (eligibility != null) {
                paymentDetails.setStatus(eligibility.optBoolean("status"));
                paymentDetails.setReason(eligibility.optString("reason"));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<String> getArrayListFromJsonArray(JSONArray jsonArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    arrayList.add(jsonArray.get(i).toString());
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    private ArrayList<PayuOffer> getOffersList(JSONArray fullArray, JSONArray offerArray) {
        if (fullArray == null || fullArray.length() == 0 || offerArray == null || offerArray.length() == 0) {
            return null;
        }
        ArrayList<PayuOffer> offersList = new ArrayList<PayuOffer>();
        for (int i = 0; i < offerArray.length(); ++i) {
            String id;
            JSONObject jsonObject = offerArray.optJSONObject(i);
            if (jsonObject == null || (id = jsonObject.optString("id")) == null || id.isEmpty() || id.equalsIgnoreCase("null")) continue;
            for (int j = 0; j < fullArray.length(); ++j) {
                String idFullArray;
                JSONObject fullJsonObject = fullArray.optJSONObject(j);
                if (fullJsonObject == null || (idFullArray = fullJsonObject.optString("id")) == null || !idFullArray.equalsIgnoreCase(id)) continue;
                PayuOffer payuOffer = new PayuOffer();
                payuOffer.setId(fullJsonObject.optString("id"));
                payuOffer.setTitle(fullJsonObject.optString("title"));
                payuOffer.setDescription(fullJsonObject.optString("description"));
                payuOffer.setMinAmount(fullJsonObject.optString("min_amount"));
                payuOffer.setDiscount(fullJsonObject.optString("discount"));
                payuOffer.setDiscountUnit(fullJsonObject.optString("discount_unit"));
                payuOffer.setOfferType(fullJsonObject.optString("offer_type"));
                payuOffer.setValidOnDays(fullJsonObject.optString("valid_on_days"));
                payuOffer.setOfferKey("@" + fullJsonObject.optString("id"));
                offersList.add(payuOffer);
            }
        }
        return offersList;
    }

    private boolean getBankDownStatus(JSONObject downInfoObject, String key, String bankCode) {
        if (downInfoObject == null || downInfoObject.length() == 0 || key == null || key.equalsIgnoreCase("cc") || key.equalsIgnoreCase("dc")) {
            return false;
        }
        JSONArray banksArray = downInfoObject.optJSONArray(key);
        if (banksArray != null && banksArray.length() != 0) {
            for (int i = 0; i < banksArray.length(); ++i) {
                if (banksArray.optString(i) == null || !banksArray.optString(i).equalsIgnoreCase(bankCode)) continue;
                return true;
            }
        }
        return false;
    }

    private String getTaxFromConfigObject(JSONObject configObject, String key) throws JSONException {
        if (configObject == null || configObject.length() == 0 || configObject.optJSONObject("taxSpecification") == null) {
            return null;
        }
        JSONObject taxSpecification = configObject.getJSONObject("taxSpecification");
        if (taxSpecification.has(key)) {
            return taxSpecification.getString(key);
        }
        if (taxSpecification.has("default")) {
            return taxSpecification.getString("default");
        }
        return null;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONObject(key) != null && paymentOptions.optJSONObject(key).optJSONObject("all") != null;
    }

    static class PaymentDetailsComparator
    implements Comparator<PaymentDetails> {
        PaymentDetailsComparator() {
        }

        @Override
        public int compare(PaymentDetails p1, PaymentDetails p2) {
            return p1.getBankName().compareTo(p2.getBankName());
        }
    }
}

