/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.EMIOptionInOffers;
import com.payu.india.Model.FetchOfferInfo;
import com.payu.india.Model.FetchofferDetails;
import com.payu.india.Model.PaymentOptionOfferinfo;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchOfferDetailsTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private FetchOfferDetailsListener mfetchOfferDetailsListener;

    public FetchOfferDetailsTask(FetchOfferDetailsListener fetchOfferDetailsListener) {
        this.mfetchOfferDetailsListener = fetchOfferDetailsListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "offers/transactions").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader()).setRequestType("application/json; charset=utf8").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                JSONObject result = response.optJSONObject("result");
                JSONArray offers = result.optJSONArray("offers");
                FetchofferDetails fetchofferDetails = new FetchofferDetails();
                ArrayList<FetchOfferInfo> offerInfoArrayList = new ArrayList<FetchOfferInfo>();
                for (int i2 = 0; i2 < offers.length(); ++i2) {
                    FetchOfferInfo fetchOfferInfo = new FetchOfferInfo();
                    JSONObject offersarray = offers.getJSONObject(i2);
                    fetchOfferInfo.setType(offersarray.optString("type"));
                    fetchOfferInfo.setOfferKey(offersarray.optString("offerKey"));
                    fetchOfferInfo.setTitle(offersarray.optString("title"));
                    fetchOfferInfo.setDescription(offersarray.optString("description"));
                    fetchOfferInfo.setTnc(offersarray.optString("tnc"));
                    fetchOfferInfo.setTncLink(offersarray.optString("tncLink"));
                    fetchOfferInfo.setMinTxnAmount(Double.parseDouble(!offersarray.get("minTxnAmount").equals(null) ? offersarray.get("minTxnAmount").toString() : "0"));
                    fetchOfferInfo.setMaxTxnAmount(Double.parseDouble(!offersarray.get("maxTxnAmount").equals(null) ? offersarray.get("maxTxnAmount").toString() : "0"));
                    fetchOfferInfo.setOfferType(offersarray.optString("offerType"));
                    fetchOfferInfo.setValidFrom(offersarray.optString("validFrom"));
                    fetchOfferInfo.setValidTo(offersarray.optString("validTo"));
                    DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
                    ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList = new ArrayList<PaymentOptionOfferinfo>();
                    if (offersarray.optJSONObject("discountDetail") != null) {
                        JSONObject discountJsonObject = offersarray.getJSONObject("discountDetail");
                        discountDetailsofOffers.setMaxDiscount(Double.parseDouble(!discountJsonObject.get("maxDiscount").equals(null) ? discountJsonObject.get("maxDiscount").toString() : "0"));
                        discountDetailsofOffers.setDiscountPercentage(discountJsonObject.optString("discountPercentage"));
                        discountDetailsofOffers.setDiscount(Double.parseDouble(!discountJsonObject.get("discount").equals(null) ? discountJsonObject.get("discount").toString() : "0"));
                        discountDetailsofOffers.setDiscountType(discountJsonObject.optString("discountType"));
                        discountDetailsofOffers.setDiscountedAmount(Double.parseDouble(!discountJsonObject.get("discountedAmount").equals(null) ? discountJsonObject.get("discountedAmount").toString() : "0"));
                        fetchOfferInfo.setDiscountDetails(discountDetailsofOffers);
                    }
                    fetchOfferInfo.setIsNoCostEmi(offersarray.optBoolean("isNoCostEmi"));
                    if (offersarray.optJSONArray("creditCard") != null) {
                        this.prepareOfferDetailsInfoForCards("creditCard", offersarray, fetchOfferInfo);
                    }
                    if (offersarray.optJSONArray("debitCard") != null) {
                        this.prepareOfferDetailsInfoForCards("debitCard", offersarray, fetchOfferInfo);
                    }
                    if (offersarray.optJSONArray("netBanking") != null) {
                        this.prepareOfferDetailsinfo("netBanking", offersarray, paymentOptionOfferinfoArrayList, fetchOfferInfo);
                    }
                    if (offersarray.optJSONArray("wallet") != null) {
                        this.prepareOfferDetailsinfo("wallet", offersarray, paymentOptionOfferinfoArrayList, fetchOfferInfo);
                    }
                    if (offersarray.optJSONArray("upi") != null) {
                        this.prepareOfferDetailsinfo("upi", offersarray, paymentOptionOfferinfoArrayList, fetchOfferInfo);
                    }
                    if (offersarray.optJSONArray("BNPL".toLowerCase()) != null) {
                        this.prepareOfferDetailsinfo("BNPL".toLowerCase(), offersarray, paymentOptionOfferinfoArrayList, fetchOfferInfo);
                    }
                    if (offersarray.optJSONObject("EMI".toLowerCase()) != null) {
                        JSONObject emiObject = offersarray.optJSONObject("EMI".toLowerCase());
                        ArrayList<EMIOptionInOffers> eMiOptionInOffersArrayList = new ArrayList<EMIOptionInOffers>();
                        eMiOptionInOffersArrayList.addAll(this.prepareOffersInfoForEmi("debitCard", emiObject));
                        eMiOptionInOffersArrayList.addAll(this.prepareOffersInfoForEmi("creditCard", emiObject));
                        fetchOfferInfo.seteMiOptionInOffersArrayList(eMiOptionInOffersArrayList);
                    }
                    offerInfoArrayList.add(fetchOfferInfo);
                    fetchofferDetails.setPayuOfferList(offerInfoArrayList);
                    payuResponse.setFetchofferDetails(fetchofferDetails);
                }
            }
        }
        catch (ProtocolException protocolException) {
        }
        catch (IOException iOException) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mfetchOfferDetailsListener.onFetchOfferDetailsResponse(payuResponse);
    }

    private void prepareOfferDetailsinfo(String paymentOption, JSONObject offersarray, ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList, FetchOfferInfo fetchOfferInfo) {
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        for (int j = 0; j < paymentOptionJson.length(); ++j) {
            JSONObject paymentDetailsForOffer = null;
            try {
                paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
            paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
            paymentOptionOfferinfo.setTitle(paymentDetailsForOffer.optString("title"));
            paymentOptionOfferinfo.setPaymentCode(paymentDetailsForOffer.optString("paymentCode"));
            paymentOptionOfferinfoArrayList.add(paymentOptionOfferinfo);
        }
        fetchOfferInfo.setPaymentOptionOfferinfolist(paymentOptionOfferinfoArrayList);
    }

    private void prepareOfferDetailsInfoForCards(String paymentOption, JSONObject offersarray, FetchOfferInfo fetchOfferInfo) throws JSONException {
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        ArrayList<PaymentOptionOfferinfo> nnetworkListForCards = new ArrayList<PaymentOptionOfferinfo>();
        ArrayList<PaymentOptionOfferinfo> bankListForCards = new ArrayList<PaymentOptionOfferinfo>();
        for (int j = 0; paymentOptionJson != null && j < paymentOptionJson.length(); ++j) {
            PaymentOptionOfferinfo paymentOptionOfferinfo;
            int k;
            JSONObject paymentDetailsForOffer = null;
            JSONArray networkDetailsOffer = null;
            JSONArray banksDetailsOffer = null;
            try {
                paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
                networkDetailsOffer = paymentDetailsForOffer.optJSONArray("networks");
                banksDetailsOffer = paymentDetailsForOffer.optJSONArray("banks");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (k = 0; k < networkDetailsOffer.length(); ++k) {
                paymentOptionOfferinfo = this.prepareCardOfferDetails(networkDetailsOffer.getJSONObject(k), paymentOption);
                nnetworkListForCards.add(paymentOptionOfferinfo);
            }
            fetchOfferInfo.setNetworkListForCards(nnetworkListForCards);
            for (k = 0; k < banksDetailsOffer.length(); ++k) {
                paymentOptionOfferinfo = this.prepareCardOfferDetails(banksDetailsOffer.getJSONObject(k), paymentOption);
                bankListForCards.add(paymentOptionOfferinfo);
            }
        }
        fetchOfferInfo.setBanksListForCards(bankListForCards);
    }

    private PaymentOptionOfferinfo prepareCardOfferDetails(JSONObject jsonObject, String paymentOption) {
        PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
        paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
        paymentOptionOfferinfo.setTitle(jsonObject.optString("title"));
        paymentOptionOfferinfo.setPaymentCode(jsonObject.optString("code"));
        return paymentOptionOfferinfo;
    }

    private ArrayList<EMIOptionInOffers> prepareOffersInfoForEmi(String paymentOption, JSONObject emiObject) {
        JSONObject emiTypeJsonObject = emiObject.optJSONObject(paymentOption);
        ArrayList<EMIOptionInOffers> eMiOptionInOffersArrayList = new ArrayList<EMIOptionInOffers>();
        if (emiTypeJsonObject != null) {
            JSONArray emiBanks = emiTypeJsonObject.optJSONArray("banks");
            for (int i = 0; i < emiBanks.length(); ++i) {
                JSONObject emiBanksObject = emiBanks.optJSONObject(i);
                EMIOptionInOffers eMiOptionInOffers = new EMIOptionInOffers();
                eMiOptionInOffers.setEmiType(paymentOption);
                eMiOptionInOffers.setBankCode(emiBanksObject.optString("bankcode"));
                ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoList = new ArrayList<PaymentOptionOfferinfo>();
                JSONArray emiTenures = emiBanksObject.optJSONArray("tenureOption");
                for (int j = 0; j < emiTenures.length(); ++j) {
                    PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
                    JSONObject emiTenuresObject = emiTenures.optJSONObject(j);
                    paymentOptionOfferinfo.setPaymentCode(emiTenuresObject.optString("paymentCode"));
                    paymentOptionOfferinfo.setTitle(emiTenuresObject.optString("title"));
                    paymentOptionOfferinfoList.add(paymentOptionOfferinfo);
                }
                eMiOptionInOffers.setPaymentOptionOfferinfoArrayList(paymentOptionOfferinfoList);
                eMiOptionInOffersArrayList.add(eMiOptionInOffers);
            }
        }
        return eMiOptionInOffersArrayList;
    }
}

