/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import java.util.HashMap;

public class HttpRequest {
    private Method method;
    private String URL;
    private HashMap<String, String> headers;
    private String postData;
    private String requestType;
    private int timeout;

    public Method getMethod() {
        return this.method;
    }

    public String getURL() {
        return this.URL;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getPostData() {
        return this.postData;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private HttpRequest(Builder builder) {
        this.method = builder.method;
        this.URL = builder.URL;
        this.headers = builder.headers;
        this.postData = builder.postData;
        this.requestType = builder.requestType;
        this.timeout = builder.timeout;
    }

    public static class Builder {
        private Method method;
        private String URL;
        private HashMap<String, String> headers;
        private String postData;
        private String requestType;
        private int timeout = -1;

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setURL(String URL2) {
            this.URL = URL2;
            return this;
        }

        public Builder setHeaders(HashMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setPostData(String postData) {
            this.postData = postData;
            return this;
        }

        public Builder setRequestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }

    public static enum Method {
        GET,
        POST,
        UPDATE,
        DELETE,
        PUT;

    }
}

