/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.PostParams;

import com.payu.india.Model.MerchantWebService;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MerchantWebServicePostParams
extends PayuUtils {
    private MerchantWebService merchantWebService;

    private MerchantWebServicePostParams() {
    }

    public MerchantWebServicePostParams(MerchantWebService merchantWebService) {
        this.merchantWebService = merchantWebService;
    }

    public PostData getMerchantWebServicePostParams() {
        StringBuilder post = new StringBuilder();
        boolean expiryMonth = false;
        boolean expiryYear = false;
        post.append(this.concatParams("udid", this.getUdid()));
        post.append(this.concatParams("imei", this.getImei()));
        if (this.merchantWebService.getKey() == null) {
            return this.getReturnData("Mandatory param key is missing");
        }
        post.append(this.concatParams("key", this.merchantWebService.getKey()));
        if (this.merchantWebService.getHash() == null) {
            return this.getReturnData("Mandatory param hash is missing");
        }
        post.append(this.concatParams("hash", this.merchantWebService.getHash()));
        if (this.merchantWebService.getCommand() == null || !PayuConstants.COMMAND_SET.contains(this.merchantWebService.getCommand())) {
            return this.getReturnData("Mandatory param command is missing");
        }
        post.append(this.concatParams("command", this.merchantWebService.getCommand()));
        switch (this.merchantWebService.getCommand()) {
            case "payment_related_details_for_mobile_sdk": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 should be user_credentials (merchant_key:unique_user_id.) to get the merchant information and stored card or default to get only the merchant information");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null) break;
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "get_checkout_details": 
            case "getEmiAmountAccordingToInterest": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "vas_for_mobile_sdk": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 Please send var1 as 'default'");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.merchantWebService.getVar2() == null ? this.concatParams("var2", "default") : this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.merchantWebService.getVar2() == null ? this.concatParams("var3", "default") : this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "get_merchant_ibibo_codes": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 Please send var1 as 'default'");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "eligibleBinsForEMI": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 Please send var1 as 'default'");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() != null) {
                    post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                }
                if (this.merchantWebService.getVar3() == null) break;
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "verify_payment": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Transaction id (txnid)if you want to verify more than one transaction please separate them by pipe : ex 6234567|45678987|4567876 ");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "check_payment": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "cancel_refund_transaction": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3  should contain the amount which needs to be refunded. Please note that both partial and full refunds are allowed.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "check_action_status": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Request ID which you get while cancel_refund_transaction api");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "capture_transaction": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing should be the Token ID(unique token from merchant)");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "update_requests": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Request ID which you get while cancel_refund_transaction api");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3should be the Bank Ref Id for the requested transaction.");
                }
                if (this.merchantWebService.getVar4() == null) {
                    return this.getReturnData("Mandatory param var4 is missing var4Amount should be a Double value example 5.00");
                }
                if (this.merchantWebService.getVar5() == null) {
                    return this.getReturnData("Mandatory param var5 is missing var5should be the Action (cancel/capture/refund)");
                }
                if (this.merchantWebService.getVar6() == null) {
                    return this.getReturnData("Mandatory param var6 is missing var6 should be new status to be set");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                post.append(this.concatParams("var4", this.merchantWebService.getVar4()));
                post.append(this.concatParams("var5", this.merchantWebService.getVar5()));
                post.append(this.concatParams("var6", this.merchantWebService.getVar6()));
                break;
            }
            case "cod_verify": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3Amount should be a Double value example 5.00");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "cod_cancel": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3Amount should be a Double value example 5.00");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "cod_settled": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("5001 var3Amount should be a Double value example 5.00");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "get_TDR": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "udf_update": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Transaction id (txnid)");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.merchantWebService.getVar2() == null ? "" : this.concatParams("var2", this.merchantWebService.getVar2()));
                post.append(this.merchantWebService.getVar3() == null ? "" : this.concatParams("var3", this.merchantWebService.getVar3()));
                post.append(this.merchantWebService.getVar4() == null ? "" : this.concatParams("var4", this.merchantWebService.getVar4()));
                post.append(this.merchantWebService.getVar5() == null ? "" : this.concatParams("var5", this.merchantWebService.getVar5()));
                post.append(this.merchantWebService.getVar6() == null ? "" : this.concatParams("var6", this.merchantWebService.getVar6()));
            }
            case "create_invoice": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                try {
                    String[] invoiceMandatoryKeys;
                    JSONObject invoiceObject = new JSONObject(this.merchantWebService.getVar1());
                    block94: for (String key : invoiceMandatoryKeys = new String[]{"amount", "txnid", "productinfo", "firstname", "email", "phone"}) {
                        if (invoiceObject.getString(key) == null || invoiceObject.getString(key).length() < 1) {
                            return this.getReturnData("Mandatory param " + key + " is missing for creating an Invoice");
                        }
                        switch (key) {
                            case "amount": {
                                try {
                                    Double.parseDouble(invoiceObject.getString(key));
                                    continue block94;
                                }
                                catch (NumberFormatException e) {
                                    return this.getReturnData(5003, "Amount should be a Double value example 5.00");
                                }
                            }
                            case "txnid": {
                                continue block94;
                            }
                            case "productinfo": {
                                continue block94;
                            }
                            case "firstname": {
                                continue block94;
                            }
                            case "email": {
                                continue block94;
                            }
                        }
                    }
                    post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                    break;
                }
                catch (JSONException e) {
                    return this.getReturnData(5014, "var1  should be a stringified JSON object; It seems there is an exception while parsing JSON");
                }
            }
            case "check_offer_status": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 should be offer key example : offer@1234 ");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2() == null ? "" : this.merchantWebService.getVar2()));
                post.append(this.concatParams("var3", this.merchantWebService.getVar3() == null ? "" : this.merchantWebService.getVar3()));
                post.append(this.concatParams("var4", this.merchantWebService.getVar4() == null ? "" : this.merchantWebService.getVar4()));
                post.append(this.concatParams("var5", this.merchantWebService.getVar5() == null ? "" : this.merchantWebService.getVar5()));
                post.append(this.concatParams("var6", this.merchantWebService.getVar6() == null ? "" : this.merchantWebService.getVar6()));
                post.append(this.concatParams("var7", this.merchantWebService.getVar7() == null ? "" : this.merchantWebService.getVar7()));
                post.append(this.concatParams("var8", this.merchantWebService.getVar8() == null ? "" : this.merchantWebService.getVar8()));
                post.append(this.concatParams("var9", this.merchantWebService.getVar9() == null ? "" : this.merchantWebService.getVar9()));
                post.append(this.concatParams("var10", this.merchantWebService.getVar10() == null ? "" : this.merchantWebService.getVar10()));
                post.append(this.concatParams("var11", this.merchantWebService.getVar11() == null ? "" : this.merchantWebService.getVar11()));
                break;
            }
            case "getNetbankingStatus": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() < 1) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the bank code for one bank, default for getting all banks");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "getIssuingBankStatus": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() != 6) {
                    return this.getReturnData("Mandatory param var1 is missing var1number or the card bin (first 6 digit of the card)");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_Transaction_Details": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the from date in YYYY-MM-DD format");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2till date in YYYY-MM-DD format.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "get_transaction_info": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the from date in YYYY-MM-DD hh:mm:ss format");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the till date in YYYY-MM-DD hh:mm:ss format.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "check_isDomestic": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() < 6) {
                    return this.getReturnData("Mandatory param var1 is missing var1number or the card bin (first 6 digit of the card)");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_payment_instrument": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_user_cards": 
            case "save_user_card": 
            case "edit_user_card": 
            case "delete_user_card": {
                break;
            }
            case "delete_store_card_cvv": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() != null && this.merchantWebService.getVar2().length() > 2) {
                    post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                    break;
                }
                return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
            }
            case "mobileHashTestWs": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_hashes": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "check_offer_details": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing");
                }
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing");
                }
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                post.append(this.concatParams("var4", this.merchantWebService.getVar4() == null ? "" : this.merchantWebService.getVar4()));
                post.append(this.concatParams("var5", this.merchantWebService.getVar5() == null ? "" : this.merchantWebService.getVar5()));
                break;
            }
            case "getBinInfo": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().isEmpty()) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                if (this.merchantWebService.getVar2() == null || this.merchantWebService.getVar2().isEmpty()) {
                    return this.getReturnData("Mandatory param var2 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar5() != null) {
                    post.append(this.concatParams("var5", this.merchantWebService.getVar5()));
                }
            }
            case "delete_payment_instrument": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
                }
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "get_payment_details": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
                }
                post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3Invalid amount");
                }
                post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "check_balance": 
            case "get_sdk_configuration": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().isEmpty()) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
            }
        }
        return this.getReturnData(0, "SUCCESS", this.trimAmpersand(post.toString()));
    }
}

