/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckBalanceListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.SodexoCardInfo;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckBalanceTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    CheckBalanceListener checkBalanceListener;

    public CheckBalanceTask(CheckBalanceListener checkBalanceListener) {
        this.checkBalanceListener = checkBalanceListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData(), payuConfig.getFetchSodexoBalanceTimeout());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(jsonResponse);
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    SodexoCardInfo sodexoCardInfo = new SodexoCardInfo();
                    sodexoCardInfo.setCardNo(jsonResponse.optString("cardNo"));
                    sodexoCardInfo.setCardBalance(jsonResponse.optString("cardBalance"));
                    sodexoCardInfo.setCardName(jsonResponse.optString("cardName"));
                    sodexoCardInfo.setMsg(jsonResponse.optString("msg"));
                    payuResponse.setSodexoCardInfo(sodexoCardInfo);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.checkBalanceListener.onCheckBalanceResponse(payuResponse);
    }
}

