/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.GetStoredCardApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetStoredCardTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private GetStoredCardApiListener mGetStoredCardApiListener;
    private StoredCard mUserCard;

    public GetStoredCardTask(GetStoredCardApiListener getStoredCardApiListener) {
        this.mGetStoredCardApiListener = getStoredCardApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                if (response.has("user_cards")) {
                    JSONObject cardsList = response.getJSONObject("user_cards");
                    Iterator keysIterator = cardsList.keys();
                    ArrayList<StoredCard> userCardArrayList = new ArrayList<StoredCard>();
                    while (keysIterator.hasNext()) {
                        String cardToken = (String)keysIterator.next();
                        StoredCard userCard = new StoredCard();
                        JSONObject card = cardsList.getJSONObject(cardToken);
                        userCard.setNameOnCard(card.getString("name_on_card"));
                        userCard.setCardName(card.getString("card_name"));
                        userCard.setExpiryYear(card.getString("expiry_year"));
                        userCard.setExpiryMonth(card.getString("expiry_month"));
                        userCard.setCardType(card.getString("card_type"));
                        userCard.setCardToken(card.getString("card_tokens"));
                        userCard.setIsExpired(card.getInt("is_expired") != 0);
                        userCard.setCardMode(card.getString("card_mode"));
                        userCard.setMaskedCardNumber(card.getString("card_no"));
                        userCard.setCardBrand(card.getString("card_brand"));
                        userCard.setCardBin(card.getString("card_bin"));
                        userCard.setIsDomestic(card.getString("isDomestic"));
                        userCardArrayList.add(userCard);
                        userCard = null;
                    }
                    payuResponse.setStoredCards(userCardArrayList);
                }
                if (response.has("msg")) {
                    postData.setResult(response.getString("msg"));
                }
                if (response.has("status")) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                } else {
                    postData.setCode(5018);
                    postData.setStatus("ERROR");
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mGetStoredCardApiListener.onGetStoredCardApiResponse(payuResponse);
    }
}

