/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.BinInfoApiListener;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class BinInfoTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    BinInfoApiListener apiListener;

    public BinInfoTask(BinInfoApiListener apiListener) {
        this.apiListener = apiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                if (jsonResponse.has("status") && jsonResponse.optInt("status") == 0) {
                    postData.setCode(5050);
                    postData.setStatus("ERROR");
                    postData.setResult(jsonResponse.optString("data") != null ? jsonResponse.optString("data") : "Something went wrong");
                } else if (jsonResponse.optInt("status") == 1) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                    CardInformation cardInformation = new CardInformation();
                    JSONObject binsData = jsonResponse.getJSONObject("data").getJSONObject("bins_data");
                    cardInformation.setIssuingBank(binsData.getString("issuing_bank"));
                    cardInformation.setBin(binsData.getString("bin"));
                    cardInformation.setCardCategory(binsData.getString("category").equalsIgnoreCase("debitcard") ? "DC" : "CC");
                    cardInformation.setCardType(binsData.getString("card_type"));
                    cardInformation.setIsZeroRedirectSupported(binsData.optInt("is_zero_redirect_supported") == 1);
                    cardInformation.setIsOtpOnTheFly(binsData.optInt("is_otp_on_the_fly") == 1);
                    cardInformation.setIsAtmPinCard(binsData.optString("is_atmpin_card").contentEquals("1"));
                    cardInformation.setIsSiSupported(binsData.optInt("is_si_supported") == 1);
                    cardInformation.setPgId(binsData.optString("pgId"));
                    cardInformation.setIsDomestic(binsData.getString("is_domestic").contentEquals("1"));
                    payuResponse.setCardInformation(cardInformation);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.apiListener.onBinInfoApiResponse(payuResponse);
    }
}

