package com.payu.paymentparamhelper;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

public class HashStringHelper {

    public HashMap<String, String> getHashString(String key, HashCommand command) {
        PaymentParams paymentParams = new PaymentParams();
        paymentParams.setKey(key);
        return getHashString(command, paymentParams);
    }

    public HashMap<String, String> getHashString(HashCommand command, PaymentParams paymentParams) {
        HashMap map = new HashMap<String, String>();
        switch (command) {
            case PaymentHash: {
                map.put(PayuConstants.HASH_STRING,
                        paymentParams.getKey() + "|" + paymentParams.getTxnId() + "|" + paymentParams.getAmount() + "|" + paymentParams.getProductInfo() + "|" +
                                paymentParams.getFirstName() + "|" + paymentParams.getEmail() + "|" + paymentParams.getUdf1() + "|" + paymentParams.getUdf2() + "|" +
                                paymentParams.getUdf3() + "|" + paymentParams.getUdf4() + "|" + paymentParams.getUdf5() + "||||||");
                map.put(PayuConstants.HASH_NAME, command.hashName);
                if (paymentParams.getSplitPaymentDetails() != null)
                    map.put(PayuConstants.POST_SALT, "|" + paymentParams.getSplitPaymentDetails());
                return map;
            }
            case SIPaymentHash: {
                if (paymentParams.getSiParams() == null) return new HashMap();

                StringBuilder siDetailsStringForHash = new StringBuilder();
                siDetailsStringForHash.append("{");
                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_START_DATE, paymentParams.getSiParams().getSi_details().getPaymentStartDate()));
                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_END_DATE, paymentParams.getSiParams().getSi_details().getPaymentEndDate()));

                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_AMOUNT, paymentParams.getSiParams().getSi_details().getBillingAmount()));
                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_CURRENCY, paymentParams.getSiParams().getSi_details().getBillingCurrency()));
                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_CYCLE, paymentParams.getSiParams().getSi_details().getBillingCycle()));
                siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_INTERVAL, paymentParams.getSiParams().getSi_details().getBillingInterval()));
                if (paymentParams.getSiParams().getSi_details().getRemarks() != null && !paymentParams.getSiParams().getSi_details().getRemarks().isEmpty()) {
                    siDetailsStringForHash.append(PayuUtils.appendKeyValueToStingBuilder(PayuConstants.BILLING_REMARKS, paymentParams.getSiParams().getSi_details().getRemarks()));
                }
                siDetailsStringForHash.deleteCharAt(siDetailsStringForHash.length()-1);
                siDetailsStringForHash.append("}");

                map.put(PayuConstants.HASH_STRING, paymentParams.getKey() + "|" + paymentParams.getTxnId() + "|" +
                        paymentParams.getAmount() + "|" + paymentParams.getProductInfo() + "|" +
                        paymentParams.getFirstName() + "|" + paymentParams.getEmail() + "|" + paymentParams.getUdf1() + "|"
                        + paymentParams.getUdf2() + "|" + paymentParams.getUdf3() + "|" + paymentParams.getUdf4() + "|" +
                        paymentParams.getUdf5() + "||||||" + siDetailsStringForHash + "|" +
                        (paymentParams.getSiParams().getSi_details() != null && paymentParams.getSiParams().isFree_trial() ? "1|" : ""));
                map.put(PayuConstants.HASH_NAME, command.hashName);

                if (paymentParams.getSplitPaymentDetails() != null)
                    map.put(PayuConstants.POST_SALT, "|" + paymentParams.getSplitPaymentDetails());

                return map;
            }
            case AuthorizePaymentHash: {
                map.put(PayuConstants.HASH_STRING,
                        paymentParams.getKey() + "|" + paymentParams.getTxnId() + "|" + paymentParams.getAmount() + "|" + "[]" + "|");
                map.put(PayuConstants.HASH_NAME, command.hashName);
                if (paymentParams.getSplitPaymentDetails() != null)
                    map.put(PayuConstants.POST_SALT, "|" + paymentParams.getSplitPaymentDetails());
                return map;
            }
            case BinInfoHash: {
                map.put(PayuConstants.HASH_STRING, paymentParams.getKey() + "|" + command.hashName + "|" + "1" + "|");
                map.put(PayuConstants.HASH_NAME, command.hashName);
                return map;
            }

        }
        return map;

    }

    public HashMap<String, String> getHashString(String key, String mihPayId, String utcDate, HashCommand command) {
        HashMap map = new HashMap<String, String>();
        map.put(PayuConstants.HASH_STRING, key + "|" + mihPayId + "|");
        map.put(PayuConstants.HASH_NAME, command.hashName);
        map.put(PayuConstants.POST_SALT, "|" + utcDate);
        return map;
    }
}
