package com.payu.paymentparamhelper.threeDS2Params;

import android.os.Parcel;
import android.os.Parcelable;

public class SDKInfo implements Parcelable {
    private String sdkEncData;
    private String sdkAppID;
    private String sdkReferenceNumber;
    private String sdkTransID;
    private String sdkMaxTimeout;
    private SDKEphemParams sdkEphemPubKey;
    private SDKDeviceRenderOptions sdkDeviceRenderOptions;

    public SDKInfo() {
    }

    protected SDKInfo(Parcel in) {
        sdkEncData = in.readString();
        sdkAppID = in.readString();
        sdkReferenceNumber = in.readString();
        sdkTransID = in.readString();
        sdkMaxTimeout = in.readString();
        sdkEphemPubKey = in.readParcelable(SDKEphemParams.class.getClassLoader());
        sdkDeviceRenderOptions = in.readParcelable(SDKDeviceRenderOptions.class.getClassLoader());
    }

    public static final Creator<SDKInfo> CREATOR = new Creator<SDKInfo>() {
        @Override
        public SDKInfo createFromParcel(Parcel in) {
            return new SDKInfo(in);
        }

        @Override
        public SDKInfo[] newArray(int size) {
            return new SDKInfo[size];
        }
    };

    public String getSdkEncData() {
        return sdkEncData;
    }

    public void setSdkEncData(String sdkEncData) {
        this.sdkEncData = sdkEncData;
    }

    public String getSdkAppID() {
        return sdkAppID;
    }

    public void setSdkAppID(String sdkAppID) {
        this.sdkAppID = sdkAppID;
    }

    public String getSdkReferenceNumber() {
        return sdkReferenceNumber;
    }

    public void setSdkReferenceNumber(String sdkReferenceNumber) {
        this.sdkReferenceNumber = sdkReferenceNumber;
    }

    public String getSdkTransID() {
        return sdkTransID;
    }

    public void setSdkTransID(String sdkTransID) {
        this.sdkTransID = sdkTransID;
    }

    public String getSdkMaxTimeout() {
        return sdkMaxTimeout;
    }

    public void setSdkMaxTimeout(String sdkMaxTimeout) {
        this.sdkMaxTimeout = sdkMaxTimeout;
    }

    public SDKEphemParams getSdkEphemPubKey() {
        return sdkEphemPubKey;
    }

    public void setSdkEphemPubKey(SDKEphemParams sdkEphemPubKey) {
        this.sdkEphemPubKey = sdkEphemPubKey;
    }

    public SDKDeviceRenderOptions getSdkDeviceRenderOptions() {
        return sdkDeviceRenderOptions;
    }

    public void setSdkDeviceRenderOptions(SDKDeviceRenderOptions sdkDeviceRenderOptions) {
        this.sdkDeviceRenderOptions = sdkDeviceRenderOptions;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(sdkEncData);
        dest.writeString(sdkAppID);
        dest.writeString(sdkReferenceNumber);
        dest.writeString(sdkTransID);
        dest.writeString(sdkMaxTimeout);
        dest.writeParcelable(sdkEphemPubKey, flags);
        dest.writeParcelable(sdkDeviceRenderOptions, flags);
    }
}
