package com.payu.paymentparamhelper;

import android.os.Parcel;
import android.os.Parcelable;

public class Sku implements Parcelable {

    private String skuId;
    private String skuAmount;
    private int quantity;
    private boolean autoApplyOffer;
    private String name;

    public Sku() {

    }

    protected Sku(Parcel in) {
        skuId = in.readString();
        skuAmount = in.readString();
        quantity = in.readInt();
        autoApplyOffer = in.readByte() != 0;
        name = in.readString();
    }

    public static final Creator<Sku> CREATOR = new Creator<Sku>() {
        @Override
        public Sku createFromParcel(Parcel in) {
            return new Sku(in);
        }

        @Override
        public Sku[] newArray(int size) {
            return new Sku[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(skuId);
        parcel.writeString(skuAmount);
        parcel.writeInt(quantity);
        parcel.writeByte((byte) (autoApplyOffer ? 1 : 0));
        parcel.writeString(name);
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public String getSkuAmount() {
        return skuAmount;
    }

    public void setSkuAmount(String skuAmount) {
        this.skuAmount = skuAmount;
    }

    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public boolean isAutoApplyOffer() {
        return autoApplyOffer;
    }

    public void setAutoApplyOffer(boolean autoApplyOffer) {
        this.autoApplyOffer = autoApplyOffer;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
