package com.payu.paymentparamhelper;

import android.os.Parcel;
import android.os.Parcelable;

public class TokenizedCardAdditionalParam implements Parcelable {
    private String last4Digits;
    private String tavv;
    private String trid;
    private String tokenRefNo;

    public TokenizedCardAdditionalParam() {
    }

    public TokenizedCardAdditionalParam(String last4Digits, String tavv, String trid, String tokenRefNo) {
        this.last4Digits = last4Digits;
        this.tavv = tavv;
        this.trid = trid;
        this.tokenRefNo = tokenRefNo;
    }

    protected TokenizedCardAdditionalParam(Parcel in) {
        last4Digits = in.readString();
        tavv = in.readString();
        trid = in.readString();
        tokenRefNo = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(last4Digits);
        dest.writeString(tavv);
        dest.writeString(trid);
        dest.writeString(tokenRefNo);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<TokenizedCardAdditionalParam> CREATOR = new Creator<TokenizedCardAdditionalParam>() {
        @Override
        public TokenizedCardAdditionalParam createFromParcel(Parcel in) {
            return new TokenizedCardAdditionalParam(in);
        }

        @Override
        public TokenizedCardAdditionalParam[] newArray(int size) {
            return new TokenizedCardAdditionalParam[size];
        }
    };

    public String getLast4Digits() {
        return last4Digits;
    }

    public void setLast4Digits(String last4Digits) {
        this.last4Digits = last4Digits;
    }

    public String getTavv() {
        return tavv;
    }

    public void setTavv(String tavv) {
        this.tavv = tavv;
    }

    public String getTrid() {
        return trid;
    }

    public void setTrid(String trid) {
        this.trid = trid;
    }

    public String getTokenRefNo() {
        return tokenRefNo;
    }

    public void setTokenRefNo(String tokenRefNo) {
        this.tokenRefNo = tokenRefNo;
    }
}
