package com.payu.paymentparamhelper;

import android.os.Parcel;
import android.os.Parcelable;

public class ConvenienceFeeCharges implements Parcelable {

    private String chargeUuid;
    private String chargeName;
    private double baseFee;
    private double taxAmount;
    private String ruleId;

    public ConvenienceFeeCharges(
            String chargeUuid,
            String chargeName,
            double baseFee,
            double taxAmount,
            String ruleId
    ) {
        this.chargeUuid = chargeUuid;
        this.chargeName = chargeName;
        this.baseFee = baseFee;
        this.taxAmount = taxAmount;
        this.ruleId = ruleId;
    }

    protected ConvenienceFeeCharges(Parcel in) {
        chargeUuid = in.readString();
        chargeName = in.readString();
        baseFee = in.readDouble();
        taxAmount = in.readDouble();
        ruleId = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(chargeUuid);
        dest.writeString(chargeName);
        dest.writeDouble(baseFee);
        dest.writeDouble(taxAmount);
        dest.writeString(ruleId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ConvenienceFeeCharges> CREATOR =
            new Creator<ConvenienceFeeCharges>() {
                @Override
                public ConvenienceFeeCharges createFromParcel(Parcel in) {
                    return new ConvenienceFeeCharges(in);
                }

                @Override
                public ConvenienceFeeCharges[] newArray(int size) {
                    return new ConvenienceFeeCharges[size];
                }
            };

    // --------------------
    // Getters
    // --------------------

    public String getChargeUuid() {
        return chargeUuid;
    }

    public String getChargeName() {
        return chargeName;
    }

    public double getBaseFee() {
        return baseFee;
    }

    public double getTaxAmount() {
        return taxAmount;
    }

    public String getRuleId() {
        return ruleId;
    }

    // --------------------
    // JSON-style toString
    // --------------------

    public String toJson() {
        return "{"
                + "\"chargeUUID\":\"" + chargeUuid + "\","
                + "\"chargeName\":\"" + chargeName + "\","
                + "\"baseFee\":" + baseFee + ","
                + "\"taxAmount\":" + taxAmount + ","
                + "\"ruleId\":\"" + ruleId + "\""
                + "}";
    }
}
