package com.payu.paymentparamhelper.siparams;

import static com.payu.paymentparamhelper.PayuConstants.BILLING_AMOUNT;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_CURRENCY;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_CYCLE;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_DATE;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_END_DATE;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_INTERVAL;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_LIMIT;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_REMARKS;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_RULE;
import static com.payu.paymentparamhelper.PayuConstants.BILLING_START_DATE;
import static com.payu.paymentparamhelper.PayuConstants.SI_FREE_TRIAL;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

import com.payu.paymentparamhelper.siparams.enums.BillingCycle;
import com.payu.paymentparamhelper.siparams.enums.BillingLimit;
import com.payu.paymentparamhelper.siparams.enums.BillingRule;

import org.json.JSONException;
import org.json.JSONObject;

public class SIParamsDetails implements Parcelable {
    private BillingCycle billingCycle;
    private int billingInterval;
    private String billingAmount;
    private String billingCurrency = "INR";
    private String paymentStartDate;
    private String paymentEndDate;
    private String remarks;
    private boolean isPreAuthTxn;
    private boolean isFreeTrial;


    public BillingLimit getBillingLimit() {
        return billingLimit;
    }

    public void setBillingLimit(BillingLimit billingLimit) {
        this.billingLimit = billingLimit;
    }

    public BillingRule getBillingRule() {
        return billingRule;
    }

    public void setBillingRule(BillingRule billingRule) {
        this.billingRule = billingRule;
    }

    public String getBillingDate() {
        return billingDate;
    }

    public void setBillingDate(String billingDate) {
        this.billingDate = billingDate;
    }

    private BillingLimit billingLimit;
    private BillingRule billingRule;
    private String billingDate;

    public void setBillingCurrency(String billingCurrency) {
        this.billingCurrency = billingCurrency;
    }

    public SIParamsDetails() {
    }

    protected SIParamsDetails(Parcel in) {
        billingInterval = in.readInt();
        billingAmount = in.readString();
        billingCurrency = in.readString();
        paymentStartDate = in.readString();
        paymentEndDate = in.readString();
        remarks = in.readString();
        billingCycle = BillingCycle.valueOf(in.readString());
        billingLimit = BillingLimit.valueOf(in.readString());
        billingRule = BillingRule.valueOf(in.readString());
        billingDate = in.readString();
        isPreAuthTxn = in.readInt() == 1;
        isFreeTrial = in.readInt() == 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(billingInterval);
        dest.writeString(billingAmount);
        dest.writeString(billingCurrency);
        dest.writeString(paymentStartDate);
        dest.writeString(paymentEndDate);
        dest.writeString(remarks);
        dest.writeString(billingCycle.name());
        dest.writeString(billingLimit.name());
        dest.writeString(billingRule.name());
        dest.writeString(billingDate);
        dest.writeInt(isPreAuthTxn ? 1 : 0);
        dest.writeInt(isFreeTrial ? 1 : 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SIParamsDetails> CREATOR = new Creator<SIParamsDetails>() {
        @Override
        public SIParamsDetails createFromParcel(Parcel in) {
            return new SIParamsDetails(in);
        }

        @Override
        public SIParamsDetails[] newArray(int size) {
            return new SIParamsDetails[size];
        }
    };

    public BillingCycle getBillingCycle() {
        return billingCycle;
    }

    public void setBillingCycle(BillingCycle billingCycle) {
        this.billingCycle = billingCycle;
    }

    public int getBillingInterval() {
        return billingInterval;
    }

    public void setBillingInterval(int billingInterval) {
        this.billingInterval = billingInterval;
    }

    public String getBillingAmount() {
        return billingAmount;
    }

    public void setBillingAmount(String billingAmount) {
        this.billingAmount = billingAmount;
    }

    public String getBillingCurrency() {
        return billingCurrency;
    }

    public String getPaymentStartDate() {
        return paymentStartDate;
    }

    public void setPaymentStartDate(String paymentStartDate) {
        this.paymentStartDate = paymentStartDate;
    }

    public String getPaymentEndDate() {
        return paymentEndDate;
    }

    public void setPaymentEndDate(String paymentEndDate) {
        this.paymentEndDate = paymentEndDate;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public boolean isPreAuthorize() {
        return isPreAuthTxn;
    }

    public void setPreAuthorize(boolean isPreAuthTxn) {
        this.isPreAuthTxn = isPreAuthTxn;
    }

    public int getPreAuthorizeAsInt() {
        if (isPreAuthTxn) {
            return 1;
        } else return 0;
    }

    public boolean isFreeTrial() {
        return isFreeTrial;
    }

    public void setFreeTrial(Boolean freeTrial) {
        isFreeTrial = freeTrial;
    }

    public JSONObject prepareSIParamsJson() {
        JSONObject siParamsObject = new JSONObject();
        try {
            if (billingCycle != null)
                siParamsObject.put(BILLING_CYCLE, billingCycle.name());
            siParamsObject.put(BILLING_INTERVAL, billingInterval);
            if (billingAmount != null && !billingAmount.isEmpty())
                siParamsObject.put(BILLING_AMOUNT, billingAmount);
            if (billingCurrency != null && !billingCurrency.isEmpty())
                siParamsObject.put(BILLING_CURRENCY, billingCurrency);
            if (paymentStartDate != null && !paymentStartDate.isEmpty())
                siParamsObject.put(BILLING_START_DATE, paymentStartDate);
            if (paymentEndDate != null && !paymentEndDate.isEmpty())
                siParamsObject.put(BILLING_END_DATE, paymentEndDate);
            if (remarks != null && !remarks.isEmpty())
                siParamsObject.put(BILLING_REMARKS, remarks);
            if (billingLimit != null)
                siParamsObject.put(BILLING_LIMIT, billingLimit.name());
            if (billingRule != null)
                siParamsObject.put(BILLING_RULE, billingRule.name());
            if (billingDate != null && !billingDate.isEmpty())
                siParamsObject.put(BILLING_DATE, billingDate);
            // Pre-authorize transaction flag
            siParamsObject.put(SI_FREE_TRIAL, isFreeTrial ? 1 : 0);
        } catch (JSONException e) {
            Log.d(getClass().getSimpleName(), "JSONException: " + e.getMessage());
        }
        return siParamsObject;
    }


}
